package org.ow2.orchestra.axis;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;

/**
 * AxisConfiguration. Keeps all configuration parameters for the given axis
 * engine.
 *
 * @author Goulven Le Jeune, Charles Souillard, Candy Chlad, Stanislas Giraudet
 *         De Boudemange, Guillaume Porcher
 *
 * Created on : Feb 21st 07
 */
public class AxisConfiguration {

  // Axis classes are run from WEB-INF/classes/, the axis configuration file is
  // in WEB-INF/
  private static String axisConfigFile = "orchestra-axis-conf.xml";

  private static AxisConfiguration configuration;

  private String host = "";

  private String port = "";

  private String webappName = "";

  private String servletPath = "";

  private String typeMapping = "";

  private String getVersionSvc = "";

  private String httpProxyHost = "";

  private String httpProxyPort = "";

  private String httpNonProxyHosts = "";

  public static synchronized AxisConfiguration getInstance() {
    if (AxisConfiguration.configuration == null) {
      InputStream input = null;
      try {
        final URL url = new URL(AxisConfiguration.axisConfigFile);
        input = url.openStream();
      } catch (final MalformedURLException e) {
        final ClassLoader classLoader = AxisConfiguration.class.getClassLoader();
        input = classLoader.getResourceAsStream(AxisConfiguration.axisConfigFile);
      } catch (final IOException e) {
        throw new OrchestraRuntimeException("Exception while loading Axis config from " + AxisConfiguration.axisConfigFile, e);
      }
      if (input != null) {
        try {
          AxisConfiguration.configuration = new AxisConfiguration();
          new AxisConfigurationFileParser().parseAndSetObject(AxisConfiguration.configuration, input);
        } finally {
          Misc.close(input);
        }
      }

    }
    return AxisConfiguration.configuration;
  }


  public static String getAxisConfigFile() {
    return AxisConfiguration.axisConfigFile;
  }

  public static void setAxisConfigFile(final String axisConfigFile) {
    AxisConfiguration.axisConfigFile = axisConfigFile;
  }

  /**
   * Returns the configuration parameters in a string.
   *
   * @return the string representing the configuration parameters
   */
  @Override
  public String toString() {
    String s = "\n";
    s += "AxisConfiguration:" + "\n\t host: " + this.host + "\n\t port: "
        + this.port + "\n\t webappName: " + this.webappName
        + "\n\t servletPath: " + this.servletPath + "\n\t typeMapping: "
        + this.typeMapping + "\n\t getVersionSvc: " + this.getVersionSvc
        + "\n\t httpProxyHost: " + this.httpProxyHost + "\n\t httpProxyPort: "
        + this.httpProxyPort + "\n\t httpNonProxyHosts: "
        + this.httpNonProxyHosts;
    s += "\n";
    return s;
  }

  /**
   * @return the getVersionSvc
   */
  public String getGetVersionSvc() {
    return this.getVersionSvc;
  }

  /**
   * @param getVersionSvc
   *            the getVersionSvc to set
   */
  public void setGetVersionSvc(final String getVersionSvc) {
    this.getVersionSvc = getVersionSvc;
  }

  /**
   * @return the host
   */
  public String getHost() {
    return this.host;
  }

  /**
   * @param host
   *            the host to set
   */
  public void setHost(final String host) {
    this.host = host;
  }

  /**
   * @return the port
   */
  public String getPort() {
    return this.port;
  }

  /**
   * @param port
   *            the port to set
   */
  public void setPort(final String port) {
    this.port = port;
  }

  /**
   * @return the servletPath
   */
  public String getServletPath() {
    return this.servletPath;
  }

  /**
   * @param servletPath
   *            the servletPath to set
   */
  public void setServletPath(final String servletPath) {
    this.servletPath = servletPath;
  }

  /**
   * @return the typeMapping
   */
  public String getTypeMapping() {
    return this.typeMapping;
  }

  /**
   * @param typeMapping
   *            the typeMapping to set
   */
  public void setTypeMapping(final String typeMapping) {
    this.typeMapping = typeMapping;
  }

  /**
   * @return the webappName
   */
  public String getWebappName() {
    return this.webappName;
  }

  /**
   * @param webappName
   *            the webappName to set
   */
  public void setWebappName(final String webappName) {
    this.webappName = webappName;
  }

  /**
   * @return the httpNonProxyHosts
   */
  public String getHttpNonProxyHosts() {
    return this.httpNonProxyHosts;
  }

  /**
   * @param httpNonProxyHosts
   *            the httpNonProxyHosts to set
   */
  public void setHttpNonProxyHosts(final String httpNonProxyHosts) {
    this.httpNonProxyHosts = httpNonProxyHosts;
  }

  /**
   * @return the httpProxyHost
   */
  public String getHttpProxyHost() {
    return this.httpProxyHost;
  }

  /**
   * @param httpProxyHost
   *            the httpProxyHost to set
   */
  public void setHttpProxyHost(final String httpProxyHost) {
    this.httpProxyHost = httpProxyHost;
  }

  /**
   * @return the httpProxyPort
   */
  public String getHttpProxyPort() {
    return this.httpProxyPort;
  }

  /**
   * @param httpProxyPort
   *            the httpProxyPort to set
   */
  public void setHttpProxyPort(final String httpProxyPort) {
    this.httpProxyPort = httpProxyPort;
  }

}
