package org.ow2.orchestra.axis;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.axis.client.AdminClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmxclient.ClientAction;

public class AxisDeployAction implements ClientAction {

  // create Options object
  private final Options options = AxisDeployAction.createDeployWSOptions();

  static final String AXIS_SERVLET_URL = "axisServletURL";

  static final String DEPLOY_WS_OPTION = "deployWS";

  protected static Options createDeployWSOptions() {
    final Options options = new Options();

    final Option deployWS = new Option(AxisDeployAction.DEPLOY_WS_OPTION, true, "deploy a WS on axis");
    deployWS.setArgName("wsdd file");
    deployWS.setRequired(true);

    final Option axisServletURL = new Option(AxisDeployAction.AXIS_SERVLET_URL, true, "axis admin servlet url");
    axisServletURL.setArgName("url");

    // Add options to the client
    options.addOption(axisServletURL);

    // Only one action at the same time
    options.addOption(deployWS);

    return options;
  }

  public static void deployWS(final String axisUrl, final URL wsddURL) {
    final String[] args = { "-l" + axisUrl };
    final AdminClient cli = new AdminClient();
    InputStream is = null;
    try {
      final org.apache.axis.utils.Options options = new org.apache.axis.utils.Options(
          args);
      is = wsddURL.openStream();
      cli.process(options, is);
    } catch (final Exception e) {
      throw new OrchestraRuntimeException("Error during deployment of " + wsddURL, e);
    } finally {
      if (is != null) {
        try {
          is.close();
        } catch (final Exception e) {
          throw new OrchestraRuntimeException(e);
        }
      }
    }
  }

  public static void deployWS(final CommandLine line) {
    String axisUrl;
    if (line.hasOption(AxisDeployAction.AXIS_SERVLET_URL)) {
      axisUrl = line.getOptionValue(AxisDeployAction.AXIS_SERVLET_URL);
    } else {
      final AxisConfiguration axisConfig = AxisConfiguration.getInstance();
      axisUrl = "http://" + axisConfig.getHost() + ":" + axisConfig.getPort()
        + "/" + axisConfig.getWebappName() + "/" + axisConfig.getServletPath();
    }
    final String wsddFile = line.getOptionValue(AxisDeployAction.DEPLOY_WS_OPTION);
    try {
      AxisDeployAction.deployWS(axisUrl, new File(wsddFile).toURL());
    } catch (final MalformedURLException e) {
      throw new OrchestraRuntimeException("Invalid wsdd url " + wsddFile, e);
    }
    System.out.println(wsddFile + " successfully deployed");
  }

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    final CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(this.options, args);
    } catch (final ParseException exp) {
      // oops, something went wrong
      return false;
    }

    AxisDeployAction.deployWS(line);

    return true;
  }

  public Options getOptions() {
    return this.options;
  }

  public String getDescription() {
    return "To deploy a web service in Axis";
  }

}
