/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.example.loanApproval;

import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.axis.transport.http.SimpleAxisServer;
import org.ow2.orchestra.axis.AxisDeployAction;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.axis.test.perf.AxisPerfTestCase;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.wsdl.WsdlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LoanApprovalTest
extends AxisPerfTestCase {
    private static final String endpoint = AxisTestCase.getDefaultEndpoint("loanServicePort");
    private static final int axisSimpleServerPort = LoanApprovalTest.getWSServerPort();
    private SimpleAxisServer simpleAxisServer = null;
    private final String wsServletURL = this.getWSServerURL();
    private static final URL approvalUndeployWsdd = LoanApprovalTest.class.getResource("approval/undeploy.wsdd");
    private static final URL riskUndeployWsdd = LoanApprovalTest.class.getResource("riskAssessment/undeploy.wsdd");

    protected String getProcessName() {
        return "loanService";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/loanApproval/loanService";
    }

    protected static int getWSServerPort() {
        URL approvalWsdl = LoanApprovalTest.class.getResource("approval/approval.wsdl");
        Definition approvalDefinition = WsdlUtil.readWsdl((URL)approvalWsdl);
        Service service = approvalDefinition.getService(new QName("http://orchestra.ow2.org/loanApproval/approval", "approvalServiceBP"));
        SOAPAddress address = (SOAPAddress)service.getPort("approvalPort").getExtensibilityElements().get(0);
        try {
            return new URL(address.getLocationURI()).getPort();
        }
        catch (MalformedURLException e) {
            throw new OrchestraRuntimeException((Exception)e);
        }
    }

    protected String getWSServerURL() {
        return "http://localhost:" + axisSimpleServerPort + "/";
    }

    public void deploy() {
        URL approvalDeployWsdd = LoanApprovalTest.class.getResource("approval/deploy.wsdd");
        URL riskDeployWsdd = LoanApprovalTest.class.getResource("riskAssessment/deploy.wsdd");
        this.simpleAxisServer = new SimpleAxisServer();
        try {
            this.simpleAxisServer.setServerSocket(new ServerSocket(axisSimpleServerPort));
            this.simpleAxisServer.start();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
        AxisDeployAction.deployWS((String)this.wsServletURL, (URL)approvalDeployWsdd);
        AxisDeployAction.deployWS((String)this.wsServletURL, (URL)riskDeployWsdd);
        this.deploy(LoanApprovalTest.class.getResource(this.getProcessName() + ".bpel"), LoanApprovalTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public void undeploy() {
        this.undeploy(new QName(this.getProcessNamespace(), this.getProcessName()));
        AxisDeployAction.deployWS((String)this.wsServletURL, (URL)approvalUndeployWsdd);
        AxisDeployAction.deployWS((String)this.wsServletURL, (URL)riskUndeployWsdd);
        this.simpleAxisServer.stop();
    }

    public long launch() {
        long endTime = -1L;
        int amount = BpelUtil.getRandomInt((long)0L, (int)60000);
        SOAPMessage response = SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", Integer.toString(amount)), (String)endpoint);
        endTime = System.currentTimeMillis();
        if (amount >= 30000) {
            this.assertResult(response, "no");
        } else {
            this.assertResult(response, "yes");
        }
        return endTime;
    }

    public void testLoanApproval() {
        try {
            this.deploy();
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "9999"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "9999"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Martin", "9999"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "10000"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "50000"), (String)endpoint), "no");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "30000"), (String)endpoint), "no");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "20000"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Martin", "10000"), (String)endpoint), "no");
            this.undeploy();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
    }

    private void assertResult(SOAPMessage response, String expected) {
        if (response != null) {
            SOAPBodyElement operationElement = null;
            try {
                operationElement = this.getSOAPBodyElement(response);
                Assert.assertNotNull((Object)operationElement);
                Assert.assertEquals((String)XmlUtil.toString((Element)operationElement), (String)"request", (String)operationElement.getLocalName());
                List elements = BpelUtil.getElements((Node)operationElement);
                Assert.assertEquals((int)1, (int)elements.size());
                Element partElement = (Element)elements.get(0);
                Assert.assertEquals((String)"accept", (String)partElement.getLocalName());
                List texts = BpelUtil.getTexts((Node)partElement);
                Assert.assertEquals((int)1, (int)texts.size());
                Assert.assertEquals((String)expected, (String)((Text)texts.get(0)).getData());
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException(e);
            }
            catch (AssertionFailedError e) {
                System.err.println("AssertionFailed, operationElement = " + BpelUtil.getNodeAsString((Node)operationElement));
                throw e;
            }
        } else {
            Assert.assertTrue((String)"No return available", (boolean)false);
        }
    }

    private SOAPMessage getRequest(String firstName, String name, String amount) {
        return SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/loanApproval/loanService", (String)("<request xmlns='http://orchestra.ow2.org/loanApproval/common'><firstName>" + firstName + "</firstName>" + "<name>" + name + "</name>" + "<amount>" + amount + "</amount>" + "</request>"));
    }

    public String getAlias() {
        return "axis.loan";
    }
}

