/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.jmx.JMXConfiguration;
import org.ow2.orchestra.jmxclient.DeployAction;
import org.ow2.orchestra.jmxclient.UndeployAction;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisTestCase
extends TestCase {
    private static Logger LOG = Logger.getLogger(AxisTestCase.class.getName());
    protected String jmxServiceUrl = JMXConfiguration.getInstance().getServiceUrl();
    protected String jmxObjectName = JMXConfiguration.getInstance().getObjectName();

    protected void deploy(String processName) {
        this.deploy(processName, null);
    }

    protected void deploy(String processName, List<URL> wsdls) {
        this.deploy(((Object)((Object)this)).getClass().getResource(processName + ".bpel"), wsdls);
    }

    protected void deploy(URL bpel, URL wsdl) {
        ArrayList<URL> wsdls = new ArrayList<URL>();
        wsdls.add(wsdl);
        this.deploy(bpel, wsdls);
    }

    protected void deploy(URL bpel, List<URL> wsdls) {
        Assert.assertNotNull((Object)DeployAction.deploy((URL)bpel, wsdls, (String)this.jmxServiceUrl, (String)this.jmxObjectName));
    }

    protected void undeploy(QName processQName) {
        Assert.assertTrue((boolean)UndeployAction.undeploy((QName)processQName, (String)this.jmxServiceUrl, (String)this.jmxObjectName));
    }

    protected SOAPBodyElement getSOAPBodyElement(SOAPMessage response) {
        if (response == null) {
            throw new OrchestraRuntimeException("response is null");
        }
        try {
            SOAPBody soapBody = response.getSOAPBody();
            if (soapBody == null) {
                throw new OrchestraRuntimeException("response.soapBody is null");
            }
            Iterator it = soapBody.getChildElements();
            if (!it.hasNext()) {
                throw new OrchestraRuntimeException("response.soapBody.children is empty");
            }
            SOAPBodyElement result = (SOAPBodyElement)it.next();
            if (it.hasNext()) {
                throw new OrchestraRuntimeException("response.soapBody.children has more than one child");
            }
            return result;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while getting soapBodyElement of message : " + response, e);
        }
    }

    protected static String getDefaultEndpoint(String portName) {
        AxisConfiguration config = AxisConfiguration.getInstance();
        String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + portName;
        return endpoint;
    }

    public <E extends BpelFaultException> E waitForExceptionInInstance(QName processQName, Class<E> exceptionClass, QName faultName) throws Exception {
        long pollInterval = 1000L;
        long timeout = 180000L;
        long startTime = System.currentTimeMillis();
        String jmxServiceUrl = JMXConfiguration.getInstance().getServiceUrl();
        String jmxObjectName = JMXConfiguration.getInstance().getObjectName();
        RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
        while (startTime + 180000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            List processDefinitions = remoteDeployer.findProcessDefinitions(processQName);
            for (ProcessDefinition processDefinition : processDefinitions) {
                Set processInstances = remoteDeployer.findProcessInstances(processDefinition.getProcessDefinitionUUID());
                for (ProcessInstance processInstance : processInstances) {
                    Set activityInstances = remoteDeployer.findActivityInstances(processInstance.getProcessInstanceUUID());
                    for (ActivityInstance activityInstance : activityInstances) {
                        BpelFaultException exception = activityInstance.getLastException();
                        if (exception == null) continue;
                        Assert.assertTrue((boolean)exceptionClass.isInstance(exception));
                        if (faultName != null) {
                            Assert.assertTrue((boolean)(exception instanceof BpelFaultException));
                            Assert.assertEquals((Object)faultName, (Object)exception.getFaultName());
                        }
                        return (E)exception;
                    }
                }
            }
        }
        Assert.fail((String)"Exception not detected when timeout occured.");
        return null;
    }

    protected void tearDown() throws Exception {
        LOG.log(Level.INFO, "=== ending " + this.getName() + " =============================\n");
        super.tearDown();
    }

    public void setUp() throws Exception {
        LOG.log(Level.INFO, "=== starting " + this.getName() + " =============================\n");
    }
}

