/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.activities.receive;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Text;

public class Receive2Test
extends AxisTestCase {
    private static final String SOAPACTION1 = "http://orchestra.ow2.org/tests/receiveSeq/receive";
    private static final String SOAPACTION2 = "http://orchestra.ow2.org/tests/receiveSeq/receive2";

    public void testReceive2() {
        try {
            String processName = "receive2";
            String processNamespace = "http://example.com/receive2";
            QName processQName = new QName(processNamespace, processName);
            URL bpelURL = org.ow2.orchestra.test.activities.receive.Receive2Test.class.getResource(processName + ".bpel");
            URL wsdlURL = org.ow2.orchestra.test.activities.receive.Receive2Test.class.getResource(processName + ".wsdl");
            this.deploy(bpelURL, wsdlURL);
            ReceiveThread rt1 = new ReceiveThread("op1", "receive1", SOAPACTION1);
            ReceiveThread rt2 = new ReceiveThread("op2", "receive2", SOAPACTION2);
            Thread t1 = new Thread(rt1);
            Thread t2 = new Thread(rt2);
            t1.start();
            t2.start();
            while (t1.isAlive() || t2.isAlive()) {
                t1.join(100L);
                t2.join(100L);
                if (rt1.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(rt1.getTrowable());
                }
                if (rt2.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread").initCause(rt2.getTrowable());
            }
            this.undeploy(processQName);
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            Receive2Test.assertTrue((boolean)false);
        }
    }

    private void checkReturn(SOAPBodyElement result, String expectedValue) {
        Receive2Test.assertNotNull((Object)result);
        Receive2Test.assertEquals((String)"response", (String)result.getElementName().getLocalName());
        Receive2Test.assertNotNull((Object)result.getFirstChild());
        Receive2Test.assertTrue((boolean)(result.getFirstChild() instanceof Text));
        Text text = (Text)result.getFirstChild();
        Receive2Test.assertEquals((String)expectedValue, (String)text.getData());
    }

    class ReceiveThread
    implements Runnable {
        private Throwable uncaughtException;
        private String operation;
        private String partValue;
        private String soapAction;

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public ReceiveThread(String operation, String partValue, String soapAction) {
            this.operation = operation;
            this.partValue = partValue;
            this.soapAction = soapAction;
        }

        public void run() {
            try {
                String endpoint = Receive2Test.getDefaultEndpoint("receive2Port");
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)this.soapAction, (String)("<" + this.operation + ">" + this.partValue + "</" + this.operation + ">"));
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response == null) {
                    Assert.assertTrue((String)("No response available for receiveThread : " + this.operation), (boolean)false);
                } else {
                    SOAPBodyElement result = Receive2Test.this.getSOAPBodyElement(response);
                    Receive2Test.this.checkReturn(result, this.partValue);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
        }
    }
}

