/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.fail;

import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.UUID;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.apache.axis.transport.http.SimpleAxisServer;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.AxisDeployAction;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.axis.test.failService.FailServiceFailure;
import org.ow2.orchestra.exception.FaultWithMessage;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.wsdl.WsdlUtil;

public class AxisFaultTest
extends AxisTestCase {
    private static final String processName = "failBpel";
    public static final String processNamespace = "http://orchestra.ow2.org/failBpel";
    private static final QName processQName = new QName("http://orchestra.ow2.org/failBpel", "failBpel");
    private static final AxisConfiguration config = AxisConfiguration.getInstance();
    private static final String webappPath = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName();
    private static final int axisSimpleServerPort = AxisFaultTest.getWSServerPort();
    private static final String adminEndpoint = "http://localhost:" + axisSimpleServerPort;
    private boolean responded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAxisFaultTransformation() throws Exception {
        Thread t = null;
        Object testException = null;
        SimpleAxisServer simpleAxisServer = new SimpleAxisServer();
        try {
            simpleAxisServer.setServerSocket(new ServerSocket(axisSimpleServerPort));
            simpleAxisServer.start();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
        AxisDeployAction.deployWS((String)adminEndpoint, (URL)AxisFaultTest.class.getResource("deploy.wsdd"));
        this.deploy(processName);
        try {
            t = new Thread(new AxisFaultTestThread(this));
            t.setDaemon(true);
            t.start();
            this.waitForExceptionInInstance(processQName, FaultWithMessage.class, FailServiceFailure.faultQName);
            Assert.assertFalse((boolean)this.responded);
        }
        finally {
            if (t != null) {
                t.interrupt();
            }
        }
        this.undeploy(processQName);
        AxisDeployAction.deployWS((String)adminEndpoint, (URL)AxisFaultTest.class.getResource("undeploy.wsdd"));
        simpleAxisServer.stop();
    }

    protected static int getWSServerPort() {
        URL failWsdl = AxisFaultTest.class.getResource("failService.wsdl");
        Definition failDefinition = WsdlUtil.readWsdl((URL)failWsdl);
        Service service = failDefinition.getService(new QName("tns:http://orchestra.ow2.org/failService/failService", "FailServiceService"));
        SOAPAddress address = (SOAPAddress)service.getPort("failPort").getExtensibilityElements().get(0);
        try {
            return new URL(address.getLocationURI()).getPort();
        }
        catch (MalformedURLException e) {
            throw new OrchestraRuntimeException((Exception)e);
        }
    }

    private class AxisFaultTestThread
    implements Runnable {
        private final AxisFaultTest axisFaultTest;

        public AxisFaultTestThread(AxisFaultTest axisFaultTest2) {
            this.axisFaultTest = axisFaultTest2;
        }

        public void run() {
            String random = UUID.randomUUID().toString();
            String part = "<failBpelRequest xmlns='http://orchestra.ow2.org/failBpel'>" + random + "</failBpelRequest>";
            String processEndpoint = webappPath + "/" + config.getServletPath() + "/" + "failBpelPort";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)AxisFaultTest.processNamespace, (String)part);
            SOAPUtil.call((SOAPMessage)request, (String)processEndpoint);
            this.axisFaultTest.responded = true;
        }
    }
}

