/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.perf;

import java.util.HashMap;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.axis.test.perf.AxisPerfTestCase;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.var.Message;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AdditionTest
extends AxisPerfTestCase {
    protected String getProcessName() {
        return "addition";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/addition";
    }

    public void deploy() {
        this.deploy(org.ow2.orchestra.test.perf.addition.AdditionTest.class.getResource(this.getProcessName() + ".bpel"), org.ow2.orchestra.test.perf.addition.AdditionTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        long endTime = -1L;
        HashMap<String, Document> parts = new HashMap<String, Document>();
        int base = BpelUtil.getRandomInt((long)0L, (int)100000);
        int toAdd = BpelUtil.getRandomInt((long)-555L, (int)100000);
        parts.put("base", BpelXmlUtil.createElementWithContent((String)Integer.toString(base)).getOwnerDocument());
        parts.put("toAdd", BpelXmlUtil.createElementWithContent((String)Integer.toString(toAdd)).getOwnerDocument());
        Message message = new Message(parts);
        SOAPMessage request = SOAPUtil.buildRpcSOAPMessage((String)"http://orchestra.ow2.org/addition/add", (Message)message, (String)"add");
        String endpoint = AdditionTest.getDefaultEndpoint("additionPort");
        try {
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            endTime = System.currentTimeMillis();
            if (response != null) {
                SOAPBodyElement result = this.getSOAPBodyElement(response);
                this.checkReturn(result, base + toAdd);
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while performing test", e);
        }
        return endTime;
    }

    private void checkReturn(SOAPBodyElement result, int total) {
        try {
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((String)"add", (String)result.getElementName().getLocalName());
            Assert.assertNotNull((Object)result.getFirstChild());
            Assert.assertTrue((boolean)(result.getFirstChild() instanceof Element));
            Element st = (Element)result.getFirstChild();
            Assert.assertEquals((String)"total", (String)st.getLocalName());
            Assert.assertNotNull((Object)st.getFirstChild());
            Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
            Text text = (Text)st.getFirstChild();
            Assert.assertEquals((int)total, (int)new Integer(text.getData()));
        }
        catch (AssertionFailedError e) {
            System.err.println("result = " + BpelUtil.getNodeAsString((Node)result));
            throw e;
        }
    }

    public void testAddition() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "axis.add";
    }
}

