/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.ow2.orchestra.axis.AxisConfigurationFileParser;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;

public class AxisConfiguration {
    private static String axisConfigFile = "orchestra-axis-conf.xml";
    private static AxisConfiguration configuration;
    private String host = "";
    private String port = "";
    private String webappName = "";
    private String servletPath = "";
    private String typeMapping = "";
    private String getVersionSvc = "";
    private String httpProxyHost = "";
    private String httpProxyPort = "";
    private String httpNonProxyHosts = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AxisConfiguration getInstance() {
        if (configuration == null) {
            InputStream input = null;
            try {
                URL url = new URL(axisConfigFile);
                input = url.openStream();
            }
            catch (MalformedURLException e) {
                ClassLoader classLoader = AxisConfiguration.class.getClassLoader();
                input = classLoader.getResourceAsStream(axisConfigFile);
            }
            catch (IOException e) {
                throw new OrchestraRuntimeException("Exception while loading Axis config from " + axisConfigFile, (Exception)e);
            }
            if (input != null) {
                try {
                    configuration = new AxisConfiguration();
                    new AxisConfigurationFileParser().parseAndSetObject(configuration, input);
                }
                finally {
                    Misc.close((Closeable)input);
                }
            }
        }
        return configuration;
    }

    public static String getAxisConfigFile() {
        return axisConfigFile;
    }

    public static void setAxisConfigFile(String axisConfigFile) {
        AxisConfiguration.axisConfigFile = axisConfigFile;
    }

    public String toString() {
        String s = "\n";
        s = s + "AxisConfiguration:\n\t host: " + this.host + "\n\t port: " + this.port + "\n\t webappName: " + this.webappName + "\n\t servletPath: " + this.servletPath + "\n\t typeMapping: " + this.typeMapping + "\n\t getVersionSvc: " + this.getVersionSvc + "\n\t httpProxyHost: " + this.httpProxyHost + "\n\t httpProxyPort: " + this.httpProxyPort + "\n\t httpNonProxyHosts: " + this.httpNonProxyHosts;
        s = s + "\n";
        return s;
    }

    public String getGetVersionSvc() {
        return this.getVersionSvc;
    }

    public void setGetVersionSvc(String getVersionSvc) {
        this.getVersionSvc = getVersionSvc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(String typeMapping) {
        this.typeMapping = typeMapping;
    }

    public String getWebappName() {
        return this.webappName;
    }

    public void setWebappName(String webappName) {
        this.webappName = webappName;
    }

    public String getHttpNonProxyHosts() {
        return this.httpNonProxyHosts;
    }

    public void setHttpNonProxyHosts(String httpNonProxyHosts) {
        this.httpNonProxyHosts = httpNonProxyHosts;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(String httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }
}

