/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis.client.AdminClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmxclient.ClientAction;

public class AxisDeployAction
implements ClientAction {
    private final Options options = AxisDeployAction.createDeployWSOptions();
    static final String AXIS_SERVLET_URL = "axisServletURL";
    static final String DEPLOY_WS_OPTION = "deployWS";

    protected static Options createDeployWSOptions() {
        Options options = new Options();
        Option deployWS = new Option(DEPLOY_WS_OPTION, true, "deploy a WS on axis");
        deployWS.setArgName("wsdd file");
        deployWS.setRequired(true);
        Option axisServletURL = new Option(AXIS_SERVLET_URL, true, "axis admin servlet url");
        axisServletURL.setArgName("url");
        options.addOption(axisServletURL);
        options.addOption(deployWS);
        return options;
    }

    public static void deployWS(String axisUrl, URL wsddURL) {
        String[] args = new String[]{"-l" + axisUrl};
        AdminClient cli = new AdminClient();
        InputStream is = null;
        try {
            org.apache.axis.utils.Options options = new org.apache.axis.utils.Options(args);
            is = wsddURL.openStream();
            cli.process(options, is);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Error during deployment of " + wsddURL, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    throw new OrchestraRuntimeException(e);
                }
            }
        }
    }

    public static void deployWS(CommandLine line) {
        String axisUrl;
        if (line.hasOption(AXIS_SERVLET_URL)) {
            axisUrl = line.getOptionValue(AXIS_SERVLET_URL);
        } else {
            AxisConfiguration axisConfig = AxisConfiguration.getInstance();
            axisUrl = "http://" + axisConfig.getHost() + ":" + axisConfig.getPort() + "/" + axisConfig.getWebappName() + "/" + axisConfig.getServletPath();
        }
        String wsddFile = line.getOptionValue(DEPLOY_WS_OPTION);
        try {
            AxisDeployAction.deployWS(axisUrl, new File(wsddFile).toURL());
        }
        catch (MalformedURLException e) {
            throw new OrchestraRuntimeException("Invalid wsdd url " + wsddFile, (Exception)e);
        }
        System.out.println(wsddFile + " successfully deployed");
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        AxisDeployAction.deployWS(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To deploy a web service in Axis";
    }
}

