/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.xml.namespace.QName;
import org.apache.axis.client.AdminClient;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.wsdl.toJava.Utils;
import org.ow2.jonas.eclipse.compiler.CompilationContext;
import org.ow2.jonas.eclipse.compiler.CompilerError;
import org.ow2.jonas.eclipse.compiler.JOnASCompiler;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.BindingFileWriter;
import org.ow2.orchestra.axis.ClassLoaderMap;
import org.ow2.orchestra.axis.ProcessClassLoader;
import org.ow2.orchestra.axis.WSDDBPELMsgProvider;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.ws.WSDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisDeployer
extends WSDeployer {
    public static final String WSDD_DEPLOY_FILE_NAME = "deploy.wsdd";
    public static final String WSDD_UNDEPLOY_FILE_NAME = "undeploy.wsdd";
    public static final String WSDD_NS = "http://xml.apache.org/axis/wsdd/";
    public static final String WSDD_SERVICE = "service";
    public static final String WSDD_SERVICE_STYLE_ATTR = "style";
    public static final String WSDD_SERVICE_PROVIDER_ATTR = "provider";
    public static final String MESSAGE_STYLE = "Message";
    public static final String NEW_WSDD_SUFFIX = ".message";
    public static final String SCOPE = "Request";
    public static final String JDK_VERSION = "1.5";
    public static final String ANT_ENV = "antEnv";
    private static Logger log = Logger.getLogger(Deployment.class.getName());
    private static File webAppTmpDir;
    private final File servicesDir;
    private final AxisConfiguration axisConfiguration;
    private final BpelProcess bpelProcess;

    public AxisDeployer(BpelProcess bpelProcess) {
        super(bpelProcess.getQName());
        this.bpelProcess = bpelProcess;
        this.axisConfiguration = AxisConfiguration.getInstance();
        this.setProxy();
        this.servicesDir = this.getServicesDir();
    }

    protected String checkOperationStyle(String operationStyle) {
        if (operationStyle == null) {
            return "Style attribute of this operation must be specified";
        }
        if (!operationStyle.equals("document") && !operationStyle.equals("rpc")) {
            return "Style attribute of this operation must be : document or rpc";
        }
        return null;
    }

    protected String checkOperationType(OperationType operationType) {
        if (!operationType.equals(OperationType.REQUEST_RESPONSE) && !operationType.equals(OperationType.ONE_WAY)) {
            return "Operation type : " + operationType + " is not supported. Please use one of : " + OperationType.ONE_WAY + "/" + OperationType.REQUEST_RESPONSE;
        }
        return null;
    }

    protected String checkSoapVersion(ExtensibilityElement soapBinding) {
        Object soapVersion = null;
        if (!(soapBinding instanceof SOAPBinding) && !(soapBinding instanceof SOAP12Binding)) {
            return "Supported Soap Version are http://schemas.xmlsoap.org/wsdl/soap//http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return null;
    }

    protected String checkTransport(ExtensibilityElement soapBinding) {
        String transportUri = "";
        if (soapBinding instanceof SOAPBinding) {
            transportUri = ((SOAPBinding)soapBinding).getTransportURI();
        } else if (soapBinding instanceof SOAP12Binding) {
            transportUri = ((SOAP12Binding)soapBinding).getTransportURI();
        }
        if (!"http://schemas.xmlsoap.org/soap/http".equals(transportUri)) {
            return "Transport URI : " + transportUri + " is not supported. Please use " + "http://schemas.xmlsoap.org/soap/http";
        }
        return null;
    }

    protected String checkUse(ExtensibilityElement element) {
        String use = "";
        if (element instanceof SOAPBody) {
            use = ((SOAPBody)element).getUse();
        } else if (element instanceof SOAP12Body) {
            use = ((SOAP12Body)element).getUse();
        } else if (element instanceof SOAPFault) {
            use = ((SOAPFault)element).getUse();
        } else if (element instanceof SOAP12Fault) {
            use = ((SOAP12Fault)element).getUse();
        }
        if (!"literal".equals(use)) {
            return "Use : " + use + " is not supported. Please use " + "literal";
        }
        return null;
    }

    protected String checkSoapBody(ExtensibilityElement soapBody) {
        List parts = null;
        if (soapBody instanceof SOAPBody) {
            parts = ((SOAPBody)soapBody).getParts();
        } else if (soapBody instanceof SOAP12Body) {
            parts = ((SOAP12Body)soapBody).getParts();
        }
        if (parts != null) {
            return "SoapBody is using parts attribute which is not currently supported.";
        }
        return null;
    }

    protected String checkSoapFault(ExtensibilityElement soapFault) {
        String name = null;
        if (soapFault instanceof SOAPFault) {
            name = ((SOAPFault)soapFault).getName();
        } else if (soapFault instanceof SOAP12Fault) {
            name = ((SOAP12Fault)soapFault).getName();
        }
        if (name == null) {
            return "SoapFault is not specifying fault name which is not currently supported.";
        }
        return null;
    }

    protected void checkWSEngineIsAvailable() {
        String urlString = "http://" + this.axisConfiguration.getHost() + ":" + this.axisConfiguration.getPort() + "/" + this.axisConfiguration.getWebappName() + "/" + this.axisConfiguration.getServletPath() + "/" + this.axisConfiguration.getGetVersionSvc();
        try {
            this.connectURL(urlString);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Axis web container is not started or Axis engine is not deployed", e);
        }
    }

    protected void deployServices(List<Service> services) {
        QName javaURI = new QName("http://xml.apache.org/axis/wsdd/providers/java", "BPELMsg");
        WSDDProvider.registerProvider((QName)javaURI, (WSDDProvider)new WSDDBPELMsgProvider());
        this.createServicesDir();
        File wsddFile = this.createWsddDeployFile(services);
        this.createWsddUndeployFile(services);
        List<String> writtenClasses = this.updateImplementationFiles(services);
        this.compileClasses(writtenClasses);
        this.addClassesToClassLoader();
        this.callAdminClientTask(wsddFile);
    }

    protected void undeployServices(List<Service> services) {
        for (File undeployWsdd : this.getUndeployFiles()) {
            this.callAdminClientTask(undeployWsdd);
        }
        this.removeClassLoader();
    }

    private void callAdminClientTask(File wsddFile) {
        ClassLoader old = ClassUtils.getDefaultClassLoader();
        try {
            ProcessClassLoader processClassLoader = ClassLoaderMap.getCL(this.processQName);
            ClassUtils.setDefaultClassLoader((ClassLoader)processClassLoader);
            AdminClient adminClient = new AdminClient();
            URL endpointURL = new URL("http://" + this.axisConfiguration.getHost() + ":" + this.axisConfiguration.getPort() + "/" + this.axisConfiguration.getWebappName() + "/" + this.axisConfiguration.getServletPath());
            adminClient.setTargetEndpointAddress(endpointURL);
            adminClient.process(wsddFile.toURL());
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception during Web service deployment.", e);
        }
        finally {
            ClassUtils.setDefaultClassLoader((ClassLoader)old);
        }
    }

    private void addClassesToClassLoader() {
        ClassLoader parent = AxisDeployer.class.getClassLoader();
        URL url = null;
        try {
            url = this.servicesDir.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OrchestraRuntimeException((Exception)e);
        }
        URL[] urls = new URL[]{url};
        ProcessClassLoader cl = new ProcessClassLoader(this.getProcessQName(), urls, parent);
        ClassLoaderMap.addCL(this.getProcessQName(), cl);
    }

    private void removeClassLoader() {
        ClassLoaderMap.removeCL(this.getProcessQName());
    }

    private void compileClasses(List<String> writtenClasses) {
        CompilationContext context = new CompilationContext();
        context.setContextualClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        context.setOutputDirectory(this.servicesDir);
        context.setSourceDirectory(this.servicesDir);
        context.setSources(writtenClasses);
        JOnASCompiler compiler = new JOnASCompiler(context);
        List errors = compiler.compile();
        String errorMsg = null;
        for (CompilerError error : errors) {
            errorMsg = errorMsg + error.toString() + Misc.LINE_SEPARATOR;
        }
        if (errorMsg != null) {
            throw new OrchestraRuntimeException("Error during compilation: " + errorMsg);
        }
    }

    private List<String> updateImplementationFiles(List<Service> services) {
        ArrayList<String> writtenClasses = new ArrayList<String>();
        for (Service service : services) {
            for (Port port : service.getPorts().values()) {
                Binding binding = port.getBinding();
                writtenClasses.add(new BindingFileWriter(this.servicesDir, binding, this.getProcessQName()).write());
            }
        }
        return writtenClasses;
    }

    private File getWsddCopy(File originalWsddFile) {
        return new File(originalWsddFile.getAbsolutePath() + NEW_WSDD_SUFFIX);
    }

    private File getDeployWsddFile(String wsdlTargetnamespace) {
        return new File(this.getWsddFilesDir(wsdlTargetnamespace) + File.separator + WSDD_DEPLOY_FILE_NAME);
    }

    private List<File> getUndeployFiles() {
        ArrayList<File> files = new ArrayList<File>();
        this.fillUndeployFiles(files, this.servicesDir);
        return files;
    }

    private void fillUndeployFiles(List<File> files, File currentDir) {
        if (currentDir.isDirectory()) {
            for (File f : currentDir.listFiles()) {
                if (f.getName().equals(WSDD_UNDEPLOY_FILE_NAME)) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                this.fillUndeployFiles(files, f);
            }
        }
    }

    private String getWsddFilesDir(String wsdlTargetnamespace) {
        String wsddFilesDir = this.servicesDir + File.separator + AxisDeployer.getDirectoryFromPackage(AxisDeployer.getPackageFromNamespace(wsdlTargetnamespace));
        return wsddFilesDir;
    }

    private void createServicesDir() {
        try {
            if (this.servicesDir.isDirectory()) {
                return;
            }
            if (!this.servicesDir.mkdir()) {
                throw new IOException("Cannot create the directory '" + this.servicesDir + "'.");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Services directory created : " + this.servicesDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Error creating " + this.servicesDir, e);
        }
    }

    private String getJarRepository() {
        File repo = new File(AxisDeployer.getWStempDir() + File.separator + "WS_Repo");
        repo.mkdirs();
        return repo.getAbsolutePath();
    }

    private static synchronized File getWStempDir() {
        if (webAppTmpDir == null) {
            try {
                new File(System.getProperty("java.io.tmpdir")).mkdirs();
                webAppTmpDir = File.createTempFile("orchWS-Repo-", null, null);
                webAppTmpDir.delete();
                if (!webAppTmpDir.mkdirs()) {
                    throw new IOException("Cannot create the temporary directory '" + webAppTmpDir + "'.");
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("webAppTmpDir created : " + webAppTmpDir.getAbsolutePath());
                }
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Error creating " + webAppTmpDir, e);
            }
        }
        return webAppTmpDir;
    }

    synchronized void resetServiceDir() {
        if (this.servicesDir != null) {
            Misc.deleteDir((File)this.servicesDir);
        }
    }

    private File getServicesDir() {
        String packag = Utils.makePackageName((String)this.getProcessQName().getNamespaceURI());
        return new File(AxisDeployer.getWStempDir() + File.separator + packag + "__" + this.getProcessQName().getLocalPart());
    }

    private URLConnection connectURL(String urlString) {
        URLConnection connection = null;
        try {
            URL getVersionURL = new URL(urlString);
            connection = getVersionURL.openConnection();
            connection.connect();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Unable to get a connection on URL : " + urlString, e);
        }
        return connection;
    }

    private void deleteServicesDir() {
        try {
            if (!Misc.deleteDir((File)this.servicesDir)) {
                throw new OrchestraRuntimeException("unable to delete directory : " + this.servicesDir);
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("unable to delete directory : " + this.servicesDir, e);
        }
    }

    public static String getPackageFromNamespace(String ns) {
        String packag = Utils.makePackageName((String)ns);
        return packag;
    }

    public static String getDirectoryFromPackage(String packag) {
        String dir = packag.replace('.', File.separatorChar);
        return dir;
    }

    private void setProxy() {
        System.getProperties().put("http.proxyHost", this.axisConfiguration.getHttpProxyHost());
        System.getProperties().put("http.proxyPort", this.axisConfiguration.getHttpProxyPort());
        System.getProperties().put("http.nonProxyHosts", this.axisConfiguration.getHttpNonProxyHosts());
    }

    private File createWsddDeployFile(List<Service> services) {
        File wsddFile = this.getDeployWsddFile(this.bpelProcess.getTargetNamespace());
        File wsddDir = wsddFile.getParentFile();
        wsddDir.mkdirs();
        OutputStreamWriter wsddFileWriter = null;
        try {
            wsddFile.createNewFile();
            wsddFileWriter = new FileWriter(wsddFile);
            wsddFileWriter.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            wsddFileWriter.write("<deployment xmlns='http://xml.apache.org/axis/wsdd/'     xmlns:java='http://xml.apache.org/axis/wsdd/providers/java'>\n");
            for (Service service : services) {
                for (Port port : service.getPorts().values()) {
                    QName bindingQN = port.getBinding().getQName();
                    String className = bindingQN.getLocalPart() + "Impl";
                    String firstLetter = className.substring(0, 1);
                    String nextLetters = className.substring(1);
                    className = firstLetter.toUpperCase() + nextLetters;
                    wsddFileWriter.write("<service name='" + port.getName() + "' provider='java:BPELMsg' style='Message' use='literal'>\n" + "<parameter name='wsdlTargetNamespace' value='" + service.getQName().getNamespaceURI() + "'/>\n" + "<parameter name='wsdlServiceElement' value='" + service.getQName().getLocalPart() + "'/>\n" + "<parameter name='wsdlServicePort' value='" + port.getName() + "'/>\n" + "<parameter name='className' value='" + AxisDeployer.getPackageFromNamespace(bindingQN.getNamespaceURI()) + "." + className + "'/>\n" + "<parameter name='wsdlPortType' value='" + port.getBinding().getPortType().getQName().getLocalPart() + "'/>\n" + "<parameter name='typeMappingVersion' value='1.3'/>\n" + "<parameter name='scope' value='Request'/>\n" + "<parameter name='bpelProcessName' value='" + this.bpelProcess.getName() + "'/>\n" + "<parameter name='bpelProcessNamespace' value='" + this.bpelProcess.getTargetNamespace() + "'/>\n");
                    for (Operation operation : port.getBinding().getPortType().getOperations()) {
                        wsddFileWriter.write("<operation name='" + operation.getName() + "' qname='operNs:" + operation.getName() + "' xmlns:operNs='" + port.getBinding().getPortType().getQName().getNamespaceURI() + "' ");
                        if (operation.getStyle().equals(OperationType.ONE_WAY)) {
                            wsddFileWriter.write("mep='oneway' />\n");
                            continue;
                        }
                        wsddFileWriter.write(" />\n");
                    }
                    wsddFileWriter.write("</service>\n");
                }
            }
            wsddFileWriter.write("</deployment>");
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Error while writting deploy.wsdd file: " + e.getMessage(), (Exception)e);
        }
        finally {
            if (wsddFileWriter != null) {
                try {
                    wsddFileWriter.close();
                }
                catch (IOException e) {}
            }
        }
        return wsddFile;
    }

    private void createWsddUndeployFile(List<Service> services) {
        File wsddFile = new File(this.getDeployWsddFile(this.bpelProcess.getTargetNamespace()).getParent() + File.separator + WSDD_UNDEPLOY_FILE_NAME);
        OutputStreamWriter wsddFileWriter = null;
        try {
            wsddFile.createNewFile();
            wsddFileWriter = new FileWriter(wsddFile);
            wsddFileWriter.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            wsddFileWriter.write("<undeployment xmlns='http://xml.apache.org/axis/wsdd/'>\n");
            for (Service service : services) {
                for (Port port : service.getPorts().values()) {
                    wsddFileWriter.write("<service name='" + port.getName() + "'/>\n");
                }
            }
            wsddFileWriter.write("</undeployment>");
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Error while writting undeploy.wsdd file: " + e.getMessage(), (Exception)e);
        }
        finally {
            if (wsddFileWriter != null) {
                try {
                    wsddFileWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

