/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.ow2.orchestra.exception.FaultWithMessage;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.var.Message;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisInvoker
implements Invoker {
    private static Logger log = Logger.getLogger(AxisInvoker.class.getName());

    public Message invoke(OperationKey operationKey, Element partnerEndPointReference, Message requestMessage, List<Service> services) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(AxisInvoker.class.getName(), "invoke", new Object[]{operationKey, partnerEndPointReference, requestMessage});
        }
        try {
            QName portTypeQName = operationKey.getPortTypeQName();
            String operationName = operationKey.getOperationName();
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            for (Service service : services) {
                for (Port port : service.getPorts().values()) {
                    List elements = port.getExtensibilityElements();
                    for (ExtensibilityElement element : elements) {
                        if (!(element instanceof SOAPAddress)) {
                            log.warning("The extensibility element: " + element.getElementType() + " is not supported!");
                            continue;
                        }
                        if (!port.getBinding().getPortType().getQName().equals(portTypeQName)) continue;
                        bindings.add(port.getBinding());
                    }
                }
            }
            if (bindings.size() == 0) {
                throw new OrchestraRuntimeException("Can't find any supported binding!");
            }
            Binding binding = (Binding)bindings.get(0);
            log.fine("Using the first binding supported: " + binding.getQName());
            Operation operation = binding.getPortType().getOperation(operationName, null, null);
            String endpoint = AxisInvoker.resolveEndPoint(partnerEndPointReference);
            String style = null;
            String use = null;
            String soapAction = null;
            for (Object elem : binding.getExtensibilityElements()) {
                if (!(elem instanceof SOAPBinding)) continue;
                SOAPBinding soapBinding = (SOAPBinding)elem;
                style = soapBinding.getStyle();
                break;
            }
            BindingOperation opBinding = binding.getBindingOperation(operationName, null, null);
            for (Object elem : opBinding.getExtensibilityElements()) {
                if (!(elem instanceof SOAPOperation)) continue;
                SOAPOperation soapOperation = (SOAPOperation)elem;
                if (soapOperation.getStyle() != null) {
                    style = soapOperation.getStyle();
                }
                soapAction = soapOperation.getSoapActionURI();
                break;
            }
            for (Object elem : opBinding.getBindingInput().getExtensibilityElements()) {
                if (!(elem instanceof SOAPBody)) continue;
                SOAPBody soapBody = (SOAPBody)elem;
                use = soapBody.getUse();
                break;
            }
            if (soapAction == null) {
                throw new OrchestraRuntimeException("No soapAction specified for this operation : " + operationName);
            }
            Map inputParts = operation.getInput().getMessage().getParts();
            if (style.equals("document") && inputParts.size() != 1) {
                throw new OrchestraRuntimeException("Style is document but input message has many parts : not supported as WSI Basic profiles requires only one part for document style");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Create the call to the endPoint['" + endpoint + "']");
            }
            SOAPMessage request = null;
            if (style.equals("document")) {
                if (requestMessage.getParts().size() != 1) {
                    throw new OrchestraRuntimeException("Trying to perform a call with many parts using document style : WSI Basic profiles does not allow that : only one part is expected (having the name of the operation");
                }
                request = SOAPUtil.buildDocumentSOAPMessage((String)soapAction, (Message)requestMessage);
            } else {
                request = SOAPUtil.buildRpcSOAPMessage((String)soapAction, (Message)requestMessage, (String)operationName);
            }
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (operation.getOutput() != null) {
                Map outputParts = operation.getOutput().getMessage().getParts();
                if (style.equals("document") && outputParts.size() != 1) {
                    throw new OrchestraRuntimeException("Style is document but output message has many parts : not supported as WSI Basic profiles requires only one part for document style");
                }
                if (response == null) {
                    throw new OrchestraRuntimeException("This operation(" + binding.getQName() + ":" + operationName + ") requires a response but no response was received");
                }
                javax.xml.soap.SOAPBody soapBody = response.getSOAPBody();
                if (soapBody.hasFault()) {
                    Iterator detailEntries;
                    Detail detail;
                    Fault fault;
                    Message faultMessage = null;
                    SOAPFault soapFault = response.getSOAPBody().getFault();
                    Name faultName = soapFault.getFaultCodeAsName();
                    QName faultQName = new QName(faultName.getURI(), faultName.getLocalName());
                    if (portTypeQName.getNamespaceURI().equals(faultName.getURI()) && (fault = operation.getFault(faultName.getLocalName())) != null && (detail = soapFault.getDetail()) != null && (detailEntries = detail.getDetailEntries()).hasNext()) {
                        DetailEntry detailEntry = (DetailEntry)detailEntries.next();
                        faultMessage = SOAPUtil.buildMessageFromDocumentSOAPBodyElement(fault.getMessage().getParts().values(), (Element)detailEntry);
                    }
                    throw new FaultWithMessage(faultQName, faultMessage);
                }
                return this.getMessageSOAPFromResponse(response, outputParts, style, use);
            }
            return null;
        }
        catch (OrchestraRuntimeException oe) {
            throw oe;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while invoke WS", e);
        }
    }

    private Message getMessageSOAPFromResponse(SOAPMessage response, Map<String, Part> outputParts, String style, String use) {
        try {
            Iterator bodyElementsIterator = response.getSOAPBody().getChildElements();
            if (!bodyElementsIterator.hasNext()) {
                throw new OrchestraRuntimeException("Exception caught while building a message from soapResponse (one and only one element was expected as a child of body but 0 were received) : " + response);
            }
            SOAPBodyElement element = (SOAPBodyElement)bodyElementsIterator.next();
            if (bodyElementsIterator.hasNext()) {
                throw new OrchestraRuntimeException("Exception caught while building a message from soapResponse (only one element was expected as a child of body but many were received) : " + response);
            }
            if (style.equals("document")) {
                return SOAPUtil.buildMessageFromDocumentSOAPBodyElement(outputParts.values(), (Element)element);
            }
            return SOAPUtil.buildMessageFromRpcSOAPBodyElement(outputParts.values(), (Element)element);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while building a message from soapResponse : " + response, e);
        }
    }

    public static String resolveEndPoint(Element serviceRefElem) {
        Element endpointRef = XmlUtil.element((Element)serviceRefElem, (String)"EndpointReference");
        Element address = XmlUtil.element((Element)endpointRef, (String)"Address");
        return address.getTextContent();
    }
}

