/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.EnvFactoryRepository;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingService;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AxisWSImpl {
    private static Logger log = Logger.getLogger(AxisWSImpl.class.getName());

    private AxisWSImpl() {
    }

    public static Element[] call(Element[] bodies, QName processQName, QName portTypeQName, String operationName, String operationStyle) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering WS Implementation, process = " + processQName + ", PT = " + portTypeQName + ", op = " + operationName + ", opStyle = " + operationStyle);
            for (Element body : bodies) {
                log.fine("body = " + body);
            }
        }
        Element[] elementsReturned = null;
        org.ow2.orchestra.var.Message incomingMessage = null;
        EnvironmentFactory environmentFactory = EnvFactoryRepository.get();
        CommandService commandService = (CommandService)environmentFactory.get(CommandService.class);
        Operation operation = (Operation)commandService.execute((Command)new GetOperationCommand(processQName, portTypeQName, operationName));
        OperationKey operationKey = new OperationKey(processQName, portTypeQName, operationName);
        incomingMessage = (org.ow2.orchestra.var.Message)commandService.execute((Command)new BuildIncomingMessageCommand(operation, processQName, operationStyle, bodies));
        if (log.isLoggable(Level.FINE)) {
            log.fine("incomingMessage = " + incomingMessage);
        }
        MessageCarrier messageCarrier = null;
        BpelExecution instance = null;
        if (operation.getOutput() != null) {
            messageCarrier = new MessageCarrier();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Doing call to receiver, messageCarrier = " + messageCarrier);
        }
        instance = ReceivingService.handle((org.ow2.orchestra.var.Message)incomingMessage, (OperationKey)operationKey, (MessageCarrier)messageCarrier);
        if (log.isLoggable(Level.FINE)) {
            log.fine("call to receiver done. Instance = " + instance);
        }
        if (operation.getOutput() != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("This operation has an output, waiting for messageCarrier...");
            }
            org.ow2.orchestra.var.Message responseMessage = messageCarrier.getMessage();
            if (operationStyle.equals("document")) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("This operation is using 'document' style.");
                }
                List<Part> parts = AxisWSImpl.getOutputParts(operation);
                elementsReturned = new Element[parts.size()];
                int i = 0;
                for (Part part : parts) {
                    elementsReturned[i] = responseMessage.getPartValue(part.getName());
                    ++i;
                }
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("This operation is using 'rpc' style.");
                }
                Document rpcDocument = SOAPUtil.buildRpcDocument((org.ow2.orchestra.var.Message)responseMessage, (String)operationName);
                elementsReturned = new Element[]{rpcDocument.getDocumentElement()};
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("elementsReturned = " + Arrays.toString(elementsReturned));
        }
        return elementsReturned;
    }

    private static Operation getOperation(PortType portType, String operationName) {
        List operations = portType.getOperations();
        for (Operation operation : operations) {
            if (!operation.getName().equals(operationName)) continue;
            return operation;
        }
        return null;
    }

    private static List<Part> getOutputParts(Operation operation) {
        Output output = operation.getOutput();
        if (output != null) {
            return AxisWSImpl.getMessageParts(output.getMessage());
        }
        return new ArrayList<Part>();
    }

    private static List<Part> getMessageParts(Message message) {
        Map partMap = message.getParts();
        Collection parts = partMap.values();
        return new ArrayList<Part>(parts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GetOperationCommand
    implements Command<Operation> {
        private final QName processQName;
        private final QName portTypeQName;
        private final String operationName;

        public GetOperationCommand(QName processQName, QName portTypeQName, String operationName) {
            this.processQName = processQName;
            this.portTypeQName = portTypeQName;
            this.operationName = operationName;
        }

        public Operation execute(Environment environment) throws Exception {
            Repository repository = (Repository)environment.get(Repository.class);
            BpelProcess bpelProcess = repository.getProcess(this.processQName);
            WsdlsInfos wsdlsInfos = bpelProcess.getWsdlInfos();
            return AxisWSImpl.getOperation(wsdlsInfos.getPortType(this.portTypeQName), this.operationName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BuildIncomingMessageCommand
    implements Command<org.ow2.orchestra.var.Message> {
        private final QName processQName;
        private final String operationStyle;
        private final Element[] bodies;
        private final Operation operation;

        public BuildIncomingMessageCommand(Operation operation, QName processQName, String operationStyle, Element[] bodies) {
            this.operation = operation;
            this.processQName = processQName;
            this.operationStyle = operationStyle;
            this.bodies = bodies;
        }

        public org.ow2.orchestra.var.Message execute(Environment environment) throws Exception {
            Repository repository = (Repository)environment.get(Repository.class);
            BpelProcess bpelProcess = repository.getProcess(this.processQName);
            WsdlsInfos wsdlsInfos = bpelProcess.getWsdlInfos();
            Message inputMessage = wsdlsInfos.getMessage(this.operation.getInput().getMessage().getQName());
            if (this.operationStyle.equals("document")) {
                return SOAPUtil.buildMessageFromDocumentSOAPBodyElement(inputMessage.getParts().values(), (Element)this.bodies[0]);
            }
            return SOAPUtil.buildMessageFromRpcSOAPBodyElement(inputMessage.getParts().values(), (Element)this.bodies[0]);
        }
    }
}

