/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.java.JavaProvider;
import org.apache.axis.providers.java.MsgProvider;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.ow2.orchestra.axis.ClassLoaderMap;
import org.ow2.orchestra.axis.ProcessClassLoader;

public class ProcessMsgProvider
extends MsgProvider {
    private static final String METHOD_BODYARRAY = "soapbodyelement";
    private static final String METHOD_ELEMENTARRAY = "element";
    private static final String METHOD_DOCUMENT = "document";

    protected Object makeNewServiceObject(MessageContext msgContext, String clsName) throws Exception {
        String processName = (String)msgContext.getService().getOption("bpelProcessName");
        String processNamespace = (String)msgContext.getService().getOption("bpelProcessNamespace");
        QName processQName = new QName(processNamespace, processName);
        ProcessClassLoader cl = ClassLoaderMap.getCL(processQName);
        ClassCache cache = msgContext.getAxisEngine().getClassCache();
        JavaClass jc = cache.lookup(clsName, (ClassLoader)cl);
        return jc.getJavaClass().newInstance();
    }

    protected Class getServiceClass(String clsName, SOAPService service, MessageContext msgContext) throws AxisFault {
        ProcessClassLoader cl = null;
        Class serviceClass = null;
        String processName = (String)service.getOption("bpelProcessName");
        String processNamespace = (String)service.getOption("bpelProcessNamespace");
        QName processQName = new QName(processNamespace, processName);
        cl = ClassLoaderMap.getCL(processQName);
        AxisEngine engine = service.getEngine();
        if (engine != null) {
            ClassCache cache = engine.getClassCache();
            try {
                JavaClass jc = cache.lookup(clsName, (ClassLoader)cl);
                serviceClass = jc.getJavaClass();
            }
            catch (ClassNotFoundException e) {
                JavaProvider.log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
                throw new AxisFault(Messages.getMessage((String)"noClassForService00", (String)clsName), (Throwable)e);
            }
        }
        try {
            serviceClass = ClassUtils.forName((String)clsName, (boolean)true, (ClassLoader)cl);
        }
        catch (ClassNotFoundException e) {
            JavaProvider.log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            throw new AxisFault(Messages.getMessage((String)"noClassForService00", (String)clsName), (Throwable)e);
        }
        return serviceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(MessageContext msgContext, SOAPEnvelope reqEnv, SOAPEnvelope resEnv, Object obj) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = obj.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            super.processMessage(msgContext, reqEnv, resEnv, obj);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    protected void setOperationStyle(MessageContext msgContext) {
        OperationDesc operation = msgContext.getOperation();
        if (operation == null || operation.getMessageOperationStyle() > -1) {
            return;
        }
        int methodType = operation.getMessageOperationStyle();
        String methodSignature = operation.getMethod().toString().toLowerCase();
        methodType = methodSignature.indexOf(METHOD_BODYARRAY) != -1 ? 1 : (methodSignature.indexOf(METHOD_ELEMENTARRAY) != -1 ? 3 : (methodSignature.indexOf(METHOD_DOCUMENT) != -1 ? 4 : 2));
        operation.setMessageOperationStyle(methodType);
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        this.setOperationStyle(msgContext);
        super.invoke(msgContext);
    }
}

