package org.ow2.orchestra.axis;

import java.io.InputStream;

/**
 * AxisConfiguration. Keeps all configuration parameters for the given axis
 * engine.
 *
 * @author Goulven Le Jeune, Charles Souillard, Candy Chlad, Stanislas Giraudet
 *         De Boudemange, Guillaume Porcher
 *
 * Created on : Feb 21st 07
 */
public class AxisConfiguration {

  // Axis classes are run from WEB-INF/classes/, the axis configuration file is
  // in WEB-INF/
  private static String axisConfigFile = "orchestra-axis-conf.xml";

  private static AxisConfiguration configuration;

  private String host = "";

  private String port = "";

  private String webappName = "";

  private String servletPath = "";

  private String typeMapping = "";

  private String getVersionSvc = "";

  private String httpProxyHost = "";

  private String httpProxyPort = "";

  private String httpNonProxyHosts = "";

  public static synchronized AxisConfiguration getInstance() {
    if (configuration == null) {
      ClassLoader classLoader = AxisConfiguration.class.getClassLoader();
      InputStream input = classLoader.getResourceAsStream(axisConfigFile);
      configuration = new AxisConfiguration();
      new AxisConfigurationFileParser().parseAndSetObject(configuration, input);
    }
    return configuration;
  }

  /**
   * Returns the configuration parameters in a string.
   *
   * @return the string representing the configuration parameters
   */
  public String toString() {
    String s = "\n";
    s += "AxisConfiguration:" + "\n\t host: " + this.host + "\n\t port: "
        + this.port + "\n\t webappName: " + this.webappName
        + "\n\t servletPath: " + this.servletPath + "\n\t typeMapping: "
        + this.typeMapping + "\n\t getVersionSvc: " + this.getVersionSvc
        + "\n\t httpProxyHost: " + this.httpProxyHost + "\n\t httpProxyPort: "
        + this.httpProxyPort + "\n\t httpNonProxyHosts: "
        + this.httpNonProxyHosts;
    s += "\n";
    return s;
  }

  /**
   * @return the getVersionSvc
   */
  public String getGetVersionSvc() {
    return getVersionSvc;
  }

  /**
   * @param getVersionSvc
   *            the getVersionSvc to set
   */
  public void setGetVersionSvc(final String getVersionSvc) {
    this.getVersionSvc = getVersionSvc;
  }

  /**
   * @return the host
   */
  public String getHost() {
    return host;
  }

  /**
   * @param host
   *            the host to set
   */
  public void setHost(final String host) {
    this.host = host;
  }

  /**
   * @return the port
   */
  public String getPort() {
    return port;
  }

  /**
   * @param port
   *            the port to set
   */
  public void setPort(final String port) {
    this.port = port;
  }

  /**
   * @return the servletPath
   */
  public String getServletPath() {
    return servletPath;
  }

  /**
   * @param servletPath
   *            the servletPath to set
   */
  public void setServletPath(final String servletPath) {
    this.servletPath = servletPath;
  }

  /**
   * @return the typeMapping
   */
  public String getTypeMapping() {
    return typeMapping;
  }

  /**
   * @param typeMapping
   *            the typeMapping to set
   */
  public void setTypeMapping(final String typeMapping) {
    this.typeMapping = typeMapping;
  }

  /**
   * @return the webappName
   */
  public String getWebappName() {
    return webappName;
  }

  /**
   * @param webappName
   *            the webappName to set
   */
  public void setWebappName(final String webappName) {
    this.webappName = webappName;
  }

  /**
   * @return the httpNonProxyHosts
   */
  public String getHttpNonProxyHosts() {
    return httpNonProxyHosts;
  }

  /**
   * @param httpNonProxyHosts
   *            the httpNonProxyHosts to set
   */
  public void setHttpNonProxyHosts(final String httpNonProxyHosts) {
    this.httpNonProxyHosts = httpNonProxyHosts;
  }

  /**
   * @return the httpProxyHost
   */
  public String getHttpProxyHost() {
    return httpProxyHost;
  }

  /**
   * @param httpProxyHost
   *            the httpProxyHost to set
   */
  public void setHttpProxyHost(final String httpProxyHost) {
    this.httpProxyHost = httpProxyHost;
  }

  /**
   * @return the httpProxyPort
   */
  public String getHttpProxyPort() {
    return httpProxyPort;
  }

  /**
   * @param httpProxyPort
   *            the httpProxyPort to set
   */
  public void setHttpProxyPort(final String httpProxyPort) {
    this.httpProxyPort = httpProxyPort;
  }

}
