/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *
 * ConfigurationFileParser.java
 *
 * @author Goulven Le Jeune, Charles Souillard, Candy Chlad, Stanislas Giraudet De Boudemange
 *
 * Created on : Feb 21st 07
 *
 * $Id:AxisConfigurationFileParser.java 813 2007-10-10 08:21:36Z souillac $
 **/
package org.ow2.orchestra.axis;

import org.ow2.orchestra.parsing.BasicFileParser;

/**
 * ConfigurationFileParser. Parses the engine and processes configuration files
 * to build the Configuration class of this process.
 * 
 * @author Goulven Le Jeune, Charles Souillard, Candy Chlad, Stanislas Giraudet
 *         De Boudemange, Guillaume Porcher
 * 
 * Created on : Feb 21st 07
 */
public class AxisConfigurationFileParser extends BasicFileParser {

  /** XML Scheme to use to parse the conf file. */
  private final String axisConfScheme = "orchestra-axis-config.xsd";

  /**
   * Returns the schema to use to parse the conf file.
   * 
   * @return the schema to use to parse the conf file.
   */
  protected String getSchema() {
    return axisConfScheme;
  }
}
