package org.ow2.orchestra.axis;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

import org.apache.axis.client.AdminClient;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.jmxclient.ClientAction;

public class AxisDeployAction implements ClientAction {

  // create Options object
  private Options options = createDeployWSOptions();

  static final String AXIS_SERVLET_URL = "axisServletURL";

  static final String DEPLOY_WS_OPTION = "deployWS";

  protected static Options createDeployWSOptions() {
    Options options = new Options();

    Option deployWS = new Option(DEPLOY_WS_OPTION, true, "deploy a WS on axis");
    deployWS.setArgName("wsdd file");
    deployWS.setRequired(true);

    Option axisServletURL = new Option(AXIS_SERVLET_URL, true, "axis admin servlet url");
    axisServletURL.setArgName("url");

    // Add options to the client
    options.addOption(axisServletURL);

    // Only one action at the same time
    options.addOption(deployWS);

    return options;
  }

  public static void deployWS(String axisUrl, URL wsddURL) {
    String[] args = { "-l" + axisUrl };
    AdminClient cli = new AdminClient();
    InputStream is = null;
    try {
      org.apache.axis.utils.Options options = new org.apache.axis.utils.Options(
          args);
      is = wsddURL.openStream();
      cli.process(options, is);
    } catch (Exception e) {
      throw new OrchestraException("Error during deployment of " + wsddURL, e);
    } finally {
      if (is != null) {
        try {
          is.close();
        } catch (Exception e) {
          throw new OrchestraException(e);
        }
      }
    }
  }

  public static void deployWS(CommandLine line) {
    String axisUrl;
    if (line.hasOption(AXIS_SERVLET_URL)) {
      axisUrl = line.getOptionValue(AXIS_SERVLET_URL);
    } else {
      AxisConfiguration axisConfig = AxisConfiguration.getInstance();
      axisUrl = "http://" + axisConfig.getHost() + ":" + axisConfig.getPort()
        + "/" + axisConfig.getWebappName() + "/servlet/AxisServlet";
    }
    String wsddFile = line.getOptionValue(DEPLOY_WS_OPTION);
    try {
      deployWS(axisUrl, new File(wsddFile).toURL());
    } catch (MalformedURLException e) {
      throw new OrchestraException("Invalid wsdd url " + wsddFile, e);
    }
    System.out.println(wsddFile + " successfully deployed");
  }

  public boolean parseAndExecute(String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    deployWS(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To deploy a web service in Axis";
  }

}
