package org.ow2.orchestra.axis;

import java.util.ArrayList;
import java.util.List;

import javax.wsdl.Service;
import javax.xml.namespace.QName;

import org.jbpm.pvm.activity.Activity;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.internal.model.NodeImpl;
import org.jbpm.pvm.model.Node;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.wsdl.WsdlsInfos;

/**
 * AxisServicePublisher.java. Implementation of the service publisher with axis.
 * 
 * @author Charles Souillard
 * 
 * Created on : Jun 26, 2007
 */
public class AxisPublisher extends PublisherImpl {

  public void publishServices(BpelProcess bpelProcess, Environment environment) {
    super.publishServices(bpelProcess, environment);
    AxisDeployer axisDeployer = new AxisDeployer(bpelProcess);
    List<Service> services = getServices(bpelProcess);
    if (services != null) {
      axisDeployer.deploy(services);
    }
  }

  public void unpublishServices(BpelProcess bpelProcess, Environment environment) {
    AxisDeployer axisDeployer = new AxisDeployer(bpelProcess);
    List<Service> services = getServices(bpelProcess);
    if (services != null) {
      axisDeployer.undeploy(services);
    }
    super.unpublishServices(bpelProcess, environment);
  }

  private List<Service> getServices(BpelProcess bpelProcess) {
    List<OperationKey> opKeys = getReceiverOpKeys(bpelProcess, (NodeImpl) bpelProcess.getInitial(), Environment.getCurrent());

    WsdlsInfos wsdlInfos = bpelProcess.getWsdlInfos();
    List<Service> services = null;
    for (OperationKey operationKey : opKeys) {
      QName portTypeQName = operationKey.getPortTypeQName();
      List<Service> portTypeServices = wsdlInfos
          .getServicesOfPortType(portTypeQName);
      if (portTypeServices != null) {
        if (services == null) {
          services = new ArrayList<Service>();
        }
        for (Service service : portTypeServices) {
          if (!services.contains(service)) {
            services.add(service);
          }
        }
      }
    }
    return services;
  }

  protected List<OperationKey> getReceiverOpKeys(BpelProcess bpelProcess, NodeImpl node,
      Environment environment) {
    List<OperationKey> opKeys = new ArrayList<OperationKey>();
    Activity behaviour = node.getBehaviour();
    if (behaviour instanceof InboundMessageElement) {
      InboundMessageElement inboundMessageElement = (InboundMessageElement) behaviour;
      for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
        opKeys.add(receivingElement.getOperationKey(bpelProcess
            .getQName()));
      }
    }
    List<Node> children = node.getNodes();
    if (children != null) {
      for (Node child : children) {
        opKeys.addAll(getReceiverOpKeys(bpelProcess, (NodeImpl) child, environment));
      }
    }
    return opKeys;
  }
  
  @Override
  public void republishServices(BpelProcess bpelProcess, Environment environment) {
    AxisDeployer axisDeployer = new AxisDeployer(bpelProcess);
    List<Service> services = getServices(bpelProcess);
    if (services != null) {
      axisDeployer.redeployServices(services);
    }
  }
}
