/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.ow2.orchestra.axis.AxisDeployer;
import org.ow2.orchestra.axis.AxisWSImpl;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.ws.WSDeployer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingFileWriter {
    private Binding binding;
    private File baseDir;
    private QName processQName;
    private BufferedWriter bw;
    private PortType portType;
    private String className;

    public BindingFileWriter(File baseDir, Binding binding, QName processQName) {
        this.baseDir = baseDir;
        this.binding = binding;
        this.processQName = processQName;
    }

    public String write() {
        QName bindingQN = this.binding.getQName();
        this.className = bindingQN.getLocalPart() + "Impl";
        String firstLetter = this.className.substring(0, 1);
        String nextLetters = this.className.substring(1);
        this.className = firstLetter.toUpperCase() + nextLetters;
        String bindingPackage = AxisDeployer.getPackageFromNamespace(bindingQN.getNamespaceURI());
        String bindingDir = AxisDeployer.getDirectoryFromPackage(bindingPackage);
        String bindingFilePath = this.baseDir + File.separator + bindingDir + File.separator + this.className + ".java";
        File fout = new File(bindingFilePath);
        this.replaceFile(fout);
        this.portType = this.binding.getPortType();
        try {
            FileWriter fw = new FileWriter(fout);
            this.bw = new BufferedWriter(fw);
            this.write("package " + bindingPackage + ";\n");
            this.addImport(Element.class);
            this.addImport(QName.class);
            this.addImport(AxisWSImpl.class);
            this.write("\n");
            this.write("public class " + this.className + " {\n");
            List operations = this.portType.getOperations();
            this.write("  QName processQName = new QName(\"" + this.processQName.getNamespaceURI() + "\", \"" + this.processQName.getLocalPart() + "\");");
            this.write("  QName portTypeQName = new QName(\"" + this.portType.getQName().getNamespaceURI() + "\", \"" + this.portType.getQName().getLocalPart() + "\");");
            this.write("\n");
            this.addOperations(operations);
            this.write("}\n");
        }
        catch (Exception e) {
            throw new OrchestraException(e);
        }
        finally {
            if (this.bw != null) {
                try {
                    this.bw.close();
                }
                catch (Exception e) {}
            }
        }
        return bindingPackage + "." + this.className;
    }

    private void addOperations(List<Operation> operations) {
        for (Operation operation : operations) {
            this.write("  public Element [] " + operation.getName() + "(Element[] bodies) {");
            this.write("    String operationName = \"" + operation.getName() + "\";");
            String operationStyle = this.getOperationStyle(operation);
            this.write("    String operationStyle = \"" + operationStyle + "\";");
            this.write("    return AxisWSImpl.call(bodies, processQName, portTypeQName, operationName, operationStyle);");
            this.write("  }");
        }
    }

    private String getOperationStyle(Operation operation) {
        String operationStyle2;
        Input input = operation.getInput();
        String inputName = null;
        if (input != null) {
            inputName = input.getName();
        }
        String outputName = null;
        Output output = operation.getOutput();
        if (output != null) {
            outputName = output.getName();
        }
        BindingOperation bindingOperation = this.binding.getBindingOperation(operation.getName(), inputName, outputName);
        ExtensibilityElement soapBinding = WSDeployer.getSoapBindingFromBinding((Binding)this.binding);
        String soapBindingStyle = WSDeployer.getSOAPStyle((ExtensibilityElement)soapBinding);
        if (soapBindingStyle == null) {
            soapBindingStyle = "document";
        }
        ExtensibilityElement soapOperation = WSDeployer.getSoapOperationFromBindingOperation((BindingOperation)bindingOperation);
        String operationStyle = soapBindingStyle;
        if (soapOperation != null && (operationStyle2 = WSDeployer.getSOAPStyle((ExtensibilityElement)soapOperation)) != null) {
            operationStyle = operationStyle2;
        }
        return operationStyle;
    }

    private void replaceFile(File f) {
        boolean created;
        f.getParentFile().mkdirs();
        if (f.exists() && !f.delete()) {
            throw new OrchestraException(this.getClass() + ".replaceFile, cannot delete file : " + f);
        }
        try {
            created = f.createNewFile();
        }
        catch (IOException e) {
            throw new OrchestraException((Exception)e);
        }
        if (!created) {
            throw new OrchestraException(this.getClass() + ".replaceFile, cannot create file : " + f);
        }
    }

    private void addImport(Class<?> clazz) {
        this.write("import " + clazz.getName() + ";");
    }

    private void write(String s) {
        try {
            this.bw.write(s + "\n");
        }
        catch (IOException e) {
            throw new OrchestraException((Exception)e);
        }
    }

    private void writeNewLine() {
        try {
            this.bw.write("\n");
        }
        catch (IOException e) {
            throw new OrchestraException((Exception)e);
        }
    }
}

