/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.perf;

import java.util.HashMap;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.axis.test.perf.AxisPerfTestCase;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.var.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class FlowTest
extends AxisPerfTestCase {
    protected String getProcessName() {
        return "flow";
    }

    protected String getProcessNamespace() {
        return "http://example.com/flow";
    }

    public void deploy() {
        this.deploy(org.ow2.orchestra.test.perf.flow.FlowTest.class.getResource(this.getProcessName() + ".bpel"), org.ow2.orchestra.test.perf.flow.FlowTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        long endTime = -1L;
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("in", BpelXmlUtil.createElementWithContent((String)"Dupont"));
        Message message = new Message(parts);
        SOAPMessage request = SOAPUtil.buildRpcSOAPMessage((String)"http://example.com/flow/submit", (Message)message, (String)"submit");
        String endpoint = this.getDefaultEndpoint("flowPort");
        try {
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            endTime = System.currentTimeMillis();
            if (response != null) {
                SOAPBodyElement result = this.getSOAPBodyElement(response);
                this.checkReturn(result, "flowResultABCDE_AE_BF");
            } else {
                FlowTest.assertTrue((String)"No return available", (boolean)false);
            }
        }
        catch (Exception e) {
            throw new OrchestraException("Exception while performing test", e);
        }
        return endTime;
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        try {
            FlowTest.assertNotNull((Object)result);
            FlowTest.assertEquals((String)"submit", (String)result.getElementName().getLocalName());
            FlowTest.assertNotNull((Object)result.getFirstChild());
            FlowTest.assertTrue((boolean)(result.getFirstChild() instanceof Element));
            Element st = (Element)result.getFirstChild();
            FlowTest.assertEquals((String)"out", (String)st.getLocalName());
            FlowTest.assertNotNull((Object)st.getFirstChild());
            FlowTest.assertTrue((boolean)(st.getFirstChild() instanceof Text));
            Text text = (Text)st.getFirstChild();
            FlowTest.assertEquals((String)name, (String)text.getData());
        }
        catch (AssertionFailedError e) {
            System.err.println("result = " + BpelUtil.getNodeAsString((Node)result));
            throw e;
        }
    }

    public void testFlow() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "axis.flow";
    }
}

