/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.receiveSeq;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ReceiveSeqTest
extends AxisTestCase {
    private static final String SOAPACTION1 = "http://orchestra.ow2.org/tests/receiveSeq/receive";
    private static final String SOAPACTION2 = "http://orchestra.ow2.org/tests/receiveSeq/receive2";

    public void testAxisReceiveSeq() {
        try {
            String processName = "receiveSeq";
            String processNamespace = "http://orchestra.ow2.org/tests/receiveSeq";
            QName processQName = new QName(processNamespace, processName);
            this.deploy(processName);
            String part = "<request>create</request>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveSeq/createInstance", (String)part);
            AxisConfiguration config = AxisConfiguration.getInstance();
            String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "createSeqPort";
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            ReceiveSeqTest.assertNull((Object)response);
            ReceiveSeqThread firstCall = new ReceiveSeqThread("first", SOAPACTION1, "receive");
            ReceiveSeqThread secondCall = new ReceiveSeqThread("second", SOAPACTION1, "receive");
            ReceiveSeqThread thirdCall = new ReceiveSeqThread("third", SOAPACTION1, "receive");
            ReceiveSeqThread fourthCall = new ReceiveSeqThread("fourth", SOAPACTION2, "receive2");
            Thread t1 = new Thread(firstCall);
            Thread t2 = new Thread(secondCall);
            Thread t3 = new Thread(thirdCall);
            Thread t4 = new Thread(fourthCall);
            t1.start();
            t2.start();
            t3.start();
            t4.start();
            while (t1.isAlive() || t2.isAlive() || t3.isAlive() || t4.isAlive()) {
                t1.join(100L);
                t2.join(100L);
                t3.join(100L);
                t4.join(100L);
                if (firstCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(firstCall.getTrowable());
                }
                if (secondCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(secondCall.getTrowable());
                }
                if (thirdCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(thirdCall.getTrowable());
                }
                if (fourthCall.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread").initCause(fourthCall.getTrowable());
            }
            this.undeploy(processQName);
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            ReceiveSeqTest.assertTrue((boolean)false);
        }
    }

    public void testAxisReceiveSeqWrongOrder() {
        try {
            String processName = "receiveSeq";
            String processNamespace = "http://orchestra.ow2.org/tests/receiveSeq";
            QName processQName = new QName(processNamespace, processName);
            this.deploy(processName);
            String part = "<request>create</request>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveSeq/createInstance", (String)part);
            AxisConfiguration config = AxisConfiguration.getInstance();
            String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "createSeqPort";
            ReceiveSeqThread firstCall = new ReceiveSeqThread("first", SOAPACTION1, "receive");
            ReceiveSeqThread secondCall = new ReceiveSeqThread("second", SOAPACTION1, "receive");
            ReceiveSeqThread thirdCall = new ReceiveSeqThread("third", SOAPACTION1, "receive");
            ReceiveSeqThread fourthCall = new ReceiveSeqThread("fourth", SOAPACTION2, "receive2");
            Thread t1 = new Thread(firstCall);
            Thread t2 = new Thread(secondCall);
            Thread t3 = new Thread(thirdCall);
            Thread t4 = new Thread(fourthCall);
            t1.start();
            t2.start();
            t3.start();
            t4.start();
            Thread.sleep(1000L);
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            ReceiveSeqTest.assertNull((Object)response);
            while (t1.isAlive() || t2.isAlive() || t3.isAlive() || t4.isAlive()) {
                t1.join(100L);
                t2.join(100L);
                t3.join(100L);
                t4.join(100L);
                if (firstCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(firstCall.getTrowable());
                }
                if (secondCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(secondCall.getTrowable());
                }
                if (thirdCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(thirdCall.getTrowable());
                }
                if (fourthCall.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread").initCause(fourthCall.getTrowable());
            }
            this.undeploy(processQName);
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            ReceiveSeqTest.assertTrue((boolean)false);
        }
    }

    static class ReceiveSeqThread
    implements Runnable {
        private Throwable uncaughtException;
        private String id;
        private String soapAction;
        private String operation;

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public ReceiveSeqThread(String text, String soapAction, String operation) {
            this.id = text;
            this.soapAction = soapAction;
            this.operation = operation;
        }

        public void run() {
            try {
                String part = "<" + this.operation + ">" + this.id + "</" + this.operation + ">";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)this.soapAction, (String)part);
                AxisConfiguration config = AxisConfiguration.getInstance();
                String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "receiveSeqPort";
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((String)XmlUtil.toString((Element)result), (boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)this.id, (String)text.getData());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
        }
    }
}

