/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.receiveFlow;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ReceiveFlowTest
extends AxisTestCase {
    public void testAxisReceiveFlow() {
        try {
            String processName = "receiveFlow";
            String processNamespace = "http://orchestra.ow2.org/tests/receiveFlow";
            QName processQName = new QName(processNamespace, processName);
            this.deploy(processName);
            String part = "<request>create</request>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveFlow/createInstance", (String)part);
            AxisConfiguration config = AxisConfiguration.getInstance();
            String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "createFlowPort";
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            ReceiveFlowTest.assertNull((Object)response);
            ReceiveFlowThread firstCall = new ReceiveFlowThread("first");
            ReceiveFlowThread secondCall = new ReceiveFlowThread("second");
            ReceiveFlowThread thirdCall = new ReceiveFlowThread("third");
            Thread t1 = new Thread(firstCall);
            Thread t2 = new Thread(secondCall);
            Thread t3 = new Thread(thirdCall);
            t1.start();
            t2.start();
            t3.start();
            while (t1.isAlive() || t2.isAlive() || t3.isAlive()) {
                t1.join(100L);
                t2.join(100L);
                t3.join(100L);
                if (firstCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(firstCall.getTrowable());
                }
                if (secondCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(secondCall.getTrowable());
                }
                if (thirdCall.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread").initCause(thirdCall.getTrowable());
            }
            this.undeploy(processQName);
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            ReceiveFlowTest.assertTrue((boolean)false);
        }
    }

    static class ReceiveFlowThread
    implements Runnable {
        private Throwable uncaughtException;
        private String id;

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public ReceiveFlowThread(String text) {
            this.id = text;
        }

        public void run() {
            try {
                String part = "<request>" + this.id + "</request>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveFlow/receive", (String)part);
                AxisConfiguration config = AxisConfiguration.getInstance();
                String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "receiveFlowPort";
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((String)XmlUtil.toString((Element)result), (boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)this.id, (String)text.getData());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
        }
    }
}

