/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.perf;

import java.util.HashMap;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.axis.test.perf.AxisPerfTestCase;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.var.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class AdditionTest
extends AxisPerfTestCase {
    protected String getProcessName() {
        return "addition";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/addition";
    }

    public void deploy() {
        this.deploy(org.ow2.orchestra.test.perf.addition.AdditionTest.class.getResource(this.getProcessName() + ".bpel"), org.ow2.orchestra.test.perf.addition.AdditionTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        long endTime = -1L;
        HashMap<String, Element> parts = new HashMap<String, Element>();
        int base = BpelUtil.getRandomInt((long)0L, (int)100000);
        int toAdd = BpelUtil.getRandomInt((long)-555L, (int)100000);
        parts.put("base", BpelXmlUtil.createElementWithContent((String)Integer.toString(base)));
        parts.put("toAdd", BpelXmlUtil.createElementWithContent((String)Integer.toString(toAdd)));
        Message message = new Message(parts);
        SOAPMessage request = SOAPUtil.buildRpcSOAPMessage((String)"http://orchestra.ow2.org/addition/add", (Message)message, (String)"add");
        String endpoint = this.getDefaultEndpoint("additionPort");
        try {
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            endTime = System.currentTimeMillis();
            if (response != null) {
                SOAPBodyElement result = this.getSOAPBodyElement(response);
                this.checkReturn(result, base + toAdd);
            } else {
                AdditionTest.assertTrue((String)"No return available", (boolean)false);
            }
        }
        catch (Exception e) {
            throw new OrchestraException("Exception while performing test", e);
        }
        return endTime;
    }

    private void checkReturn(SOAPBodyElement result, int total) {
        try {
            AdditionTest.assertNotNull((Object)result);
            AdditionTest.assertEquals((String)"add", (String)result.getElementName().getLocalName());
            AdditionTest.assertNotNull((Object)result.getFirstChild());
            AdditionTest.assertTrue((boolean)(result.getFirstChild() instanceof Element));
            Element st = (Element)result.getFirstChild();
            AdditionTest.assertEquals((String)"total", (String)st.getLocalName());
            AdditionTest.assertNotNull((Object)st.getFirstChild());
            AdditionTest.assertTrue((boolean)(st.getFirstChild() instanceof Text));
            Text text = (Text)st.getFirstChild();
            AdditionTest.assertEquals((int)total, (int)new Integer(text.getData()));
        }
        catch (AssertionFailedError e) {
            System.err.println("result = " + BpelUtil.getNodeAsString((Node)result));
            throw e;
        }
    }

    public void testAddition() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "axis.add";
    }
}

