/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.tools.ant.axis.AdminClientTask;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.BindingFileWriter;
import org.ow2.orchestra.axis.ClassLoaderMap;
import org.ow2.orchestra.axis.ProcessClassLoader;
import org.ow2.orchestra.axis.WSDDBPELMsgProvider;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.deployment.Deployment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.JMXAgent;
import org.ow2.orchestra.services.MutexRepository;
import org.ow2.orchestra.ws.WSDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisDeployer
extends WSDeployer {
    public static final String WSDD_DEPLOY_FILE_NAME = "deploy.wsdd";
    public static final String WSDD_UNDEPLOY_FILE_NAME = "undeploy.wsdd";
    public static final String WSDD_NS = "http://xml.apache.org/axis/wsdd/";
    public static final String WSDD_SERVICE = "service";
    public static final String WSDD_SERVICE_STYLE_ATTR = "style";
    public static final String WSDD_SERVICE_PROVIDER_ATTR = "provider";
    public static final String MESSAGE_STYLE = "Message";
    public static final String NEW_WSDD_SUFFIX = ".message";
    public static final String SCOPE = "Request";
    public static final String JDK_VERSION = "1.5";
    public static final String ANT_ENV = "antEnv";
    private static Logger log = Logger.getLogger(Deployment.class.getName());
    private Project antProject;
    private File tmpDir;
    private AxisConfiguration axisConfiguration;
    private BpelProcess bpelProcess;

    public AxisDeployer(BpelProcess bpelProcess) {
        super(bpelProcess.getQName());
        this.bpelProcess = bpelProcess;
        this.setAntProject();
        this.axisConfiguration = AxisConfiguration.getInstance();
        this.setProxy();
    }

    protected String checkOperationStyle(String operationStyle) {
        if (operationStyle == null) {
            return "Style attribute of this operation must be specified";
        }
        if (!operationStyle.equals("document") && !operationStyle.equals("rpc")) {
            return "Style attribute of this operation must be : document or rpc";
        }
        return null;
    }

    protected String checkOperationType(OperationType operationType) {
        if (!operationType.equals(OperationType.REQUEST_RESPONSE) && !operationType.equals(OperationType.ONE_WAY)) {
            return "Operation type : " + operationType + " is not supported. Please use one of : " + OperationType.ONE_WAY + "/" + OperationType.REQUEST_RESPONSE;
        }
        return null;
    }

    protected String checkSoapVersion(ExtensibilityElement soapBinding) {
        Object soapVersion = null;
        if (!(soapBinding instanceof SOAPBinding) && !(soapBinding instanceof SOAP12Binding)) {
            return "Supported Soap Version are http://schemas.xmlsoap.org/wsdl/soap//http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return null;
    }

    protected String checkTransport(ExtensibilityElement soapBinding) {
        String transportUri = "";
        if (soapBinding instanceof SOAPBinding) {
            transportUri = ((SOAPBinding)soapBinding).getTransportURI();
        } else if (soapBinding instanceof SOAP12Binding) {
            transportUri = ((SOAP12Binding)soapBinding).getTransportURI();
        }
        if (!"http://schemas.xmlsoap.org/soap/http".equals(transportUri)) {
            return "Transport URI : " + transportUri + " is not supported. Please use " + "http://schemas.xmlsoap.org/soap/http";
        }
        return null;
    }

    protected String checkUse(ExtensibilityElement element) {
        String use = "";
        if (element instanceof SOAPBody) {
            use = ((SOAPBody)element).getUse();
        } else if (element instanceof SOAP12Body) {
            use = ((SOAP12Body)element).getUse();
        } else if (element instanceof SOAPFault) {
            use = ((SOAPFault)element).getUse();
        } else if (element instanceof SOAP12Fault) {
            use = ((SOAP12Fault)element).getUse();
        }
        if (!"literal".equals(use)) {
            return "Use : " + use + " is not supported. Please use " + "literal";
        }
        return null;
    }

    protected String checkSoapBody(ExtensibilityElement soapBody) {
        List parts = null;
        if (soapBody instanceof SOAPBody) {
            parts = ((SOAPBody)soapBody).getParts();
        } else if (soapBody instanceof SOAP12Body) {
            parts = ((SOAP12Body)soapBody).getParts();
        }
        if (parts != null) {
            return "SoapBody is using parts attribute which is not currently supported.";
        }
        return null;
    }

    protected String checkSoapFault(ExtensibilityElement soapFault) {
        String name = null;
        if (soapFault instanceof SOAPFault) {
            name = ((SOAPFault)soapFault).getName();
        } else if (soapFault instanceof SOAP12Fault) {
            name = ((SOAP12Fault)soapFault).getName();
        }
        if (name == null) {
            return "SoapFault is not specifying fault name which is not currently supported.";
        }
        return null;
    }

    protected void checkWSEngineIsAvailable() {
        String urlString = "http://" + this.axisConfiguration.getHost() + ":" + this.axisConfiguration.getPort() + "/" + this.axisConfiguration.getWebappName() + "/" + this.axisConfiguration.getServletPath() + "/" + this.axisConfiguration.getGetVersionSvc();
        try {
            this.connectURL(urlString);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Axis web container is not started or Axis engine is not deployed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployServices(List<Service> services) {
        QName javaURI = new QName("http://xml.apache.org/axis/wsdd/providers/java", "BPELMsg");
        WSDDProvider.registerProvider((QName)javaURI, (WSDDProvider)new WSDDBPELMsgProvider());
        MutexRepository.ProcessLock processLock = MutexRepository.lockProcess((QName)this.getProcessQName());
        try {
            this.createTmpDir();
            try {
                File wsddFile = this.createWsddDeployFile(services);
                this.createWsddUndeployFile(services);
                this.updateImplementationFiles(services);
                this.deployJarToWebServer();
                this.callAdminClientTask(wsddFile);
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Exception caught in " + ((Object)((Object)this)).getClass(), e);
            }
            finally {
                this.deleteTmpDir();
            }
        }
        finally {
            MutexRepository.unlockProcess((MutexRepository.ProcessLock)processLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployServices(List<Service> services) {
        MutexRepository.ProcessLock processLock = MutexRepository.lockProcess((QName)this.getProcessQName());
        try {
            this.createTmpDir();
            try {
                this.extractJarFile();
                for (File undeployWsdd : this.getUndeployFiles()) {
                    this.callAdminClientTask(undeployWsdd);
                }
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Exception caught in " + ((Object)((Object)this)).getClass(), e);
            }
            finally {
                this.deleteTmpDir();
            }
        }
        finally {
            MutexRepository.unlockProcess((MutexRepository.ProcessLock)processLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeployServices(List<Service> services) {
        MutexRepository.ProcessLock processLock = MutexRepository.lockProcess((QName)this.getProcessQName());
        try {
            this.createTmpDir();
            try {
                this.extractJarFile();
                ClassLoader parent = AxisDeployer.class.getClassLoader();
                URL url = null;
                try {
                    url = new File(this.getJarRepository() + File.separator + this.getJarName()).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new OrchestraRuntimeException((Exception)e);
                }
                URL[] urls = new URL[]{url};
                ProcessClassLoader cl = new ProcessClassLoader(this.getProcessQName(), urls, parent);
                ClassLoaderMap.addCL(this.getProcessQName(), cl);
                for (File deployWsdd : this.getDeployFiles()) {
                    this.callAdminClientTask(deployWsdd);
                }
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Exception caught in " + ((Object)((Object)this)).getClass(), e);
            }
            finally {
                this.deleteTmpDir();
            }
        }
        finally {
            MutexRepository.unlockProcess((MutexRepository.ProcessLock)processLock);
        }
    }

    private void extractJarFile() {
        String jarRepository = this.getJarRepository();
        File jarFile = new File(jarRepository + File.separator + this.getJarName());
        Expand unjar = new Expand();
        unjar.setProject(this.antProject);
        unjar.setSrc(jarFile);
        unjar.setDest(this.tmpDir);
        unjar.setTaskName("unjar");
        unjar.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callAdminClientTask(File wsddFile) {
        ClassLoader old = ClassUtils.getDefaultClassLoader();
        try {
            ProcessClassLoader processClassLoader = ClassLoaderMap.getCL(this.processQName);
            ClassUtils.setDefaultClassLoader((ClassLoader)processClassLoader);
            AdminClientTask adminClientTask = new AdminClientTask();
            adminClientTask.setProject(this.antProject);
            adminClientTask.init();
            adminClientTask.setUrl("-lhttp://" + this.axisConfiguration.getHost() + ":" + this.axisConfiguration.getPort() + "/" + this.axisConfiguration.getWebappName() + "/servlet/AxisServlet");
            adminClientTask.setXmlFile(wsddFile);
            adminClientTask.setTaskName("adminClientTask");
            adminClientTask.execute();
        }
        finally {
            ClassUtils.setDefaultClassLoader((ClassLoader)old);
        }
    }

    private void deployJarToWebServer() {
        this.compileClasses();
        File jarFile = this.createJar();
        File destJarFile = this.deployJar(jarFile);
        ClassLoader parent = AxisDeployer.class.getClassLoader();
        URL url = null;
        try {
            url = destJarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OrchestraRuntimeException((Exception)e);
        }
        URL[] urls = new URL[]{url};
        ProcessClassLoader cl = new ProcessClassLoader(this.getProcessQName(), urls, parent);
        ClassLoaderMap.addCL(this.getProcessQName(), cl);
    }

    private File createJar() {
        File jarFile = this.getWSJarFile();
        Jar j = new Jar();
        j.setTaskName("jar");
        j.setProject(this.antProject);
        j.setDestFile(jarFile);
        FileSet fs1 = new FileSet();
        fs1.setDir(this.tmpDir);
        j.addFileset(fs1);
        j.execute();
        return jarFile;
    }

    private File deployJar(File jarFile) {
        String jarRepository = this.getJarRepository();
        File destJarFile = new File(jarRepository + File.separator + this.getJarName());
        Copy c = new Copy();
        c.setProject(this.antProject);
        c.setFile(jarFile);
        c.setTofile(destJarFile);
        c.setTaskName("copy");
        c.execute();
        return destJarFile;
    }

    private void compileClasses() {
        Javac j = new Javac();
        j.setProject(this.antProject);
        j.setDestdir(this.tmpDir);
        Path srcDir = new Path(this.antProject);
        srcDir.setLocation(this.tmpDir);
        j.setSrcdir(srcDir);
        FileSet fileset = new FileSet();
        fileset.setDir(new File(this.getWebappLibDir()));
        fileset.setIncludes("**/*.jar");
        Path classpath = new Path(this.antProject);
        classpath.addFileset(fileset);
        j.setClasspath(classpath);
        j.setVerbose(false);
        j.setFork(true);
        j.setIncludes("**/*.java");
        j.setTaskName("javac");
        j.setSource(JDK_VERSION);
        j.setDebug(true);
        j.init();
        j.execute();
    }

    private List<String> updateImplementationFiles(List<Service> services) {
        ArrayList<String> writtenClasses = new ArrayList<String>();
        for (Service service : services) {
            for (Port port : service.getPorts().values()) {
                Binding binding = port.getBinding();
                writtenClasses.add(new BindingFileWriter(this.tmpDir, binding, this.getProcessQName()).write());
            }
        }
        return writtenClasses;
    }

    private File getWsddCopy(File originalWsddFile) {
        return new File(originalWsddFile.getAbsolutePath() + NEW_WSDD_SUFFIX);
    }

    private File getDeployWsddFile(String wsdlTargetnamespace) {
        return new File(this.getWsddFilesDir(wsdlTargetnamespace) + File.separator + WSDD_DEPLOY_FILE_NAME);
    }

    private List<File> getUndeployFiles() {
        ArrayList<File> files = new ArrayList<File>();
        this.fillUndeployFiles(files, this.tmpDir);
        return files;
    }

    private void fillUndeployFiles(List<File> files, File currentDir) {
        for (File f : currentDir.listFiles()) {
            if (f.getName().equals(WSDD_UNDEPLOY_FILE_NAME)) {
                files.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.fillUndeployFiles(files, f);
        }
    }

    private List<File> getDeployFiles() {
        ArrayList<File> files = new ArrayList<File>();
        this.fillDeployFiles(files, this.tmpDir);
        return files;
    }

    private void fillDeployFiles(List<File> files, File currentDir) {
        for (File f : currentDir.listFiles()) {
            if (f.getName().equals(WSDD_DEPLOY_FILE_NAME)) {
                files.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.fillDeployFiles(files, f);
        }
    }

    private String getWsddFilesDir(String wsdlTargetnamespace) {
        String wsddFilesDir = this.tmpDir + File.separator + AxisDeployer.getDirectoryFromPackage(AxisDeployer.getPackageFromNamespace(wsdlTargetnamespace));
        return wsddFilesDir;
    }

    private void createTmpDir() {
        try {
            new File(System.getProperty("java.io.tmpdir")).mkdirs();
            this.tmpDir = File.createTempFile("orch", null, null);
            this.tmpDir.delete();
            if (!this.tmpDir.mkdirs()) {
                throw new IOException("Cannot create the temporary directory '" + this.tmpDir + "'.");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("tmpDir created : " + this.tmpDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Error creating " + this.tmpDir, e);
        }
    }

    private String getJarRepository() {
        File repo = new File(this.getWebappLibDir() + File.separator + "WS_Repo");
        repo.mkdirs();
        return repo.getAbsolutePath();
    }

    private String getWsdlRepository() {
        File repo = new File(this.getJarRepository() + File.separator + "wsdl");
        repo.mkdirs();
        return repo.getAbsolutePath();
    }

    private String getWebappLibDir() {
        URL envUrl = Thread.currentThread().getContextClassLoader().getResource(JMXAgent.defaultEnvConfigFile);
        String envPath = envUrl.getPath();
        String rootDir = envPath.substring(0, envPath.lastIndexOf(JMXAgent.defaultEnvConfigFile));
        String path = rootDir + ".." + File.separator + "lib";
        if (!new File(path).isDirectory()) {
            throw new OrchestraRuntimeException("Error while deploying web services : dir " + path + " does not exist.");
        }
        return path;
    }

    private File getWSJarFile() {
        return new File(this.tmpDir + File.separator + this.getJarName());
    }

    private String getJarName() {
        String packag = Utils.makePackageName((String)this.getProcessQName().getNamespaceURI());
        return packag + "__" + this.getProcessQName().getLocalPart() + ".jar";
    }

    private String getWsdlName() {
        String packag = Utils.makePackageName((String)this.getProcessQName().getNamespaceURI());
        return packag + "__" + this.getProcessQName().getLocalPart() + ".wsdl";
    }

    private URLConnection connectURL(String urlString) {
        URLConnection connection = null;
        try {
            URL getVersionURL = new URL(urlString);
            connection = getVersionURL.openConnection();
            connection.connect();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Unable to get a connection on URL : ", e);
        }
        return connection;
    }

    private void deleteDir(File dir) {
        Delete d = new Delete();
        d.setTaskName("delete");
        d.setDir(dir);
        d.setProject(this.antProject);
        d.execute();
    }

    private void deleteTmpDir() {
        try {
            this.deleteDir(this.tmpDir);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(((Object)((Object)this)).getClass() + ".deleteGeneratedFiles, unable to delete directory : " + this.tmpDir, e);
        }
    }

    private void setAntProject() {
        this.antProject = new Project();
        DefaultLogger dl = new DefaultLogger();
        dl.setMessageOutputLevel(2);
        dl.setErrorPrintStream(System.out);
        dl.setOutputPrintStream(System.out);
        dl.setEmacsMode(false);
        this.antProject.addBuildListener((BuildListener)dl);
        this.antProject.init();
        Property p = new Property();
        p.setEnvironment(ANT_ENV);
        p.setProject(this.antProject);
        p.execute();
    }

    public static String getPackageFromNamespace(String ns) {
        String packag = Utils.makePackageName((String)ns);
        return packag;
    }

    public static String getDirectoryFromPackage(String packag) {
        String dir = packag.replace('.', File.separatorChar);
        return dir;
    }

    private void setProxy() {
        System.getProperties().put("http.proxyHost", this.axisConfiguration.getHttpProxyHost());
        System.getProperties().put("http.proxyPort", this.axisConfiguration.getHttpProxyPort());
        System.getProperties().put("http.nonProxyHosts", this.axisConfiguration.getHttpNonProxyHosts());
    }

    private File createWsddDeployFile(List<Service> services) {
        File wsddFile = this.getDeployWsddFile(this.bpelProcess.getTargetNamespace());
        File wsddDir = wsddFile.getParentFile();
        wsddDir.mkdirs();
        OutputStreamWriter wsddFileWriter = null;
        try {
            wsddFile.createNewFile();
            wsddFileWriter = new FileWriter(wsddFile);
            wsddFileWriter.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            wsddFileWriter.write("<deployment xmlns='http://xml.apache.org/axis/wsdd/'     xmlns:java='http://xml.apache.org/axis/wsdd/providers/java'>\n");
            for (Service service : services) {
                for (Port port : service.getPorts().values()) {
                    QName bindingQN = port.getBinding().getQName();
                    String className = bindingQN.getLocalPart() + "Impl";
                    String firstLetter = className.substring(0, 1);
                    String nextLetters = className.substring(1);
                    className = firstLetter.toUpperCase() + nextLetters;
                    wsddFileWriter.write("<service name='" + port.getName() + "' provider='java:BPELMsg' style='Message' use='literal'>\n" + "<parameter name='wsdlTargetNamespace' value='" + service.getQName().getNamespaceURI() + "'/>\n" + "<parameter name='wsdlServiceElement' value='" + service.getQName().getLocalPart() + "'/>\n" + "<parameter name='wsdlServicePort' value='" + port.getName() + "'/>\n" + "<parameter name='className' value='" + AxisDeployer.getPackageFromNamespace(bindingQN.getNamespaceURI()) + "." + className + "'/>\n" + "<parameter name='wsdlPortType' value='" + port.getBinding().getPortType().getQName().getLocalPart() + "'/>\n" + "<parameter name='typeMappingVersion' value='1.3'/>\n" + "<parameter name='scope' value='Request'/>\n" + "<parameter name='bpelProcessName' value='" + this.bpelProcess.getName() + "'/>\n" + "<parameter name='bpelProcessNamespace' value='" + this.bpelProcess.getTargetNamespace() + "'/>\n");
                    for (Operation operation : port.getBinding().getPortType().getOperations()) {
                        wsddFileWriter.write("<operation name='" + operation.getName() + "' qname='operNs:" + operation.getName() + "' xmlns:operNs='" + port.getBinding().getPortType().getQName().getNamespaceURI() + "' ");
                        if (operation.getStyle().equals(OperationType.ONE_WAY)) {
                            wsddFileWriter.write("mep='oneway' />\n");
                            continue;
                        }
                        wsddFileWriter.write(" />\n");
                    }
                    wsddFileWriter.write("</service>\n");
                }
            }
            wsddFileWriter.write("</deployment>");
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Error while writting deploy.wsdd file: " + e.getMessage(), (Exception)e);
        }
        finally {
            if (wsddFileWriter != null) {
                try {
                    wsddFileWriter.close();
                }
                catch (IOException e) {}
            }
        }
        return wsddFile;
    }

    private void createWsddUndeployFile(List<Service> services) {
        File wsddFile = new File(this.getDeployWsddFile(this.bpelProcess.getTargetNamespace()).getParent() + File.separator + WSDD_UNDEPLOY_FILE_NAME);
        OutputStreamWriter wsddFileWriter = null;
        try {
            wsddFile.createNewFile();
            wsddFileWriter = new FileWriter(wsddFile);
            wsddFileWriter.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            wsddFileWriter.write("<undeployment xmlns='http://xml.apache.org/axis/wsdd/'>\n");
            for (Service service : services) {
                for (Port port : service.getPorts().values()) {
                    wsddFileWriter.write("<service name='" + port.getName() + "'/>\n");
                }
            }
            wsddFileWriter.write("</undeployment>");
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Error while writting undeploy.wsdd file: " + e.getMessage(), (Exception)e);
        }
        finally {
            if (wsddFileWriter != null) {
                try {
                    wsddFileWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

