/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.TestCase;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.InstanceInfo;
import org.ow2.orchestra.jmx.JMXConfiguration;
import org.ow2.orchestra.jmx.ProcessInfo;
import org.ow2.orchestra.jmxclient.DeployAction;
import org.ow2.orchestra.jmxclient.GetProcessAction;
import org.ow2.orchestra.jmxclient.ListInstanceAction;
import org.ow2.orchestra.jmxclient.ListProcessAction;
import org.ow2.orchestra.jmxclient.UndeployAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisTestCase
extends TestCase {
    protected String jmxServiceUrl = JMXConfiguration.getInstance().getServiceUrl();
    protected String jmxObjectName = JMXConfiguration.getInstance().getObjectName();

    protected void deploy(String processName) {
        this.deploy(processName, null);
    }

    protected void deploy(String processName, List<URL> wsdls) {
        this.deploy(((Object)((Object)this)).getClass().getResource(processName + ".bpel"), wsdls);
    }

    protected void deploy(URL bpel, URL wsdl) {
        ArrayList<URL> wsdls = new ArrayList<URL>();
        wsdls.add(wsdl);
        this.deploy(bpel, wsdls);
    }

    protected void deploy(URL bpel, List<URL> wsdls) {
        AxisTestCase.assertNotNull((Object)DeployAction.deploy((URL)bpel, wsdls, (String)this.jmxServiceUrl, (String)this.jmxObjectName));
    }

    protected void getProcess(QName processQName) {
        ProcessInfo processInfo = GetProcessAction.get((String)this.jmxServiceUrl, (String)this.jmxObjectName, (QName)processQName);
        System.out.println("*** process info: " + processInfo.getQname());
    }

    protected void listInstance() {
        Map instances = null;
        List processNames = ListProcessAction.list((String)this.jmxServiceUrl, (String)this.jmxObjectName);
        instances = ListInstanceAction.list((String)this.jmxServiceUrl, (String)this.jmxObjectName);
        System.out.println("List of running instances per process:");
        for (QName qName : processNames) {
            System.out.println("Process qname = " + qName);
            List insts = (List)instances.get(qName);
            for (InstanceInfo instRec : insts) {
                System.out.println("instance uid = " + instRec.getInstanceUId() + " nodeName =" + instRec.getNodeName() + "= " + " state = " + instRec.getState());
            }
        }
    }

    protected void undeploy(QName processQName) {
        AxisTestCase.assertTrue((boolean)UndeployAction.undeploy((QName)processQName, (String)this.jmxServiceUrl, (String)this.jmxObjectName));
    }

    protected SOAPBodyElement getSOAPBodyElement(SOAPMessage response) {
        if (response == null) {
            throw new OrchestraRuntimeException("response is null");
        }
        try {
            SOAPBody soapBody = response.getSOAPBody();
            if (soapBody == null) {
                throw new OrchestraRuntimeException("response.soapBody is null");
            }
            Iterator it = soapBody.getChildElements();
            if (!it.hasNext()) {
                throw new OrchestraRuntimeException("response.soapBody.children is empty");
            }
            SOAPBodyElement result = (SOAPBodyElement)it.next();
            if (it.hasNext()) {
                throw new OrchestraRuntimeException("response.soapBody.children has more than one child");
            }
            return result;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while getting soapBodyElement of message : " + response, e);
        }
    }

    protected String getDefaultEndpoint(String portName) {
        AxisConfiguration config = AxisConfiguration.getInstance();
        String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + portName;
        return endpoint;
    }

    static {
        try {
            InputStream inputStream = AxisTestCase.class.getClassLoader().getResourceAsStream("logging.properties");
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

