/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.querier;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.facade.QuerierRuntimeAPI;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.ProcessState;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.JMXConfiguration;
import org.ow2.orchestra.util.SOAPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APITest
extends AxisTestCase {
    private static final String NAME_SPACE = "http://orchestra.ow2.org/tests/querier/";

    @Override
    public void deploy(String processName) {
        this.deploy(processName, Collections.singletonList(((Object)((Object)this)).getClass().getResource("apitest.wsdl")));
    }

    public void undeploy(String processName) {
        this.undeploy(new QName(NAME_SPACE, processName));
    }

    public Future<SOAPMessage> startProcess(String processName) {
        String operationName = "submit";
        String part = "<submit>bidon</submit>";
        final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/querier/submit", (String)part);
        AxisConfiguration config = AxisConfiguration.getInstance();
        final String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "querierPort";
        FutureTask<SOAPMessage> futureTask = new FutureTask<SOAPMessage>(new Callable<SOAPMessage>(){

            @Override
            public SOAPMessage call() {
                return SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            }
        });
        new Thread(futureTask).start();
        return futureTask;
    }

    public Future<SOAPMessage> continueProcess(String processName) {
        String operationName = "submit";
        String part = "<submit>bidon</submit>";
        final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/querier/submit", (String)part);
        AxisConfiguration config = AxisConfiguration.getInstance();
        final String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "querierContinuePort";
        FutureTask<SOAPMessage> futureTask = new FutureTask<SOAPMessage>(new Callable<SOAPMessage>(){

            @Override
            public SOAPMessage call() {
                return SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            }
        });
        new Thread(futureTask).start();
        return futureTask;
    }

    public void testFindProcessInstances() throws Exception {
        String processName = "apitest1";
        this.deploy(processName);
        String jmxServiceUrl = JMXConfiguration.getInstance().getServiceUrl();
        String jmxObjectName = JMXConfiguration.getInstance().getObjectName();
        RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
        int initialRunned = remoteDeployer.findProcessInstances(ProcessState.FINISHED).size();
        Set previousRunningProcess = remoteDeployer.findProcessInstances(ProcessState.RUNNING);
        Future<SOAPMessage> soapMessageFutureStart = this.startProcess(processName);
        Future<SOAPMessage> soapMessageFutureContinue = this.continueProcess(processName);
        soapMessageFutureContinue.get();
        Set runningProcess = remoteDeployer.findProcessInstances(ProcessState.RUNNING);
        APITest.assertEquals((String)"No new process found", (int)(previousRunningProcess.size() + 1), (int)runningProcess.size());
        Iterator it = runningProcess.iterator();
        ProcessInstanceUUID processInstanceUUID = null;
        while (it.hasNext()) {
            ProcessInstance processInstance = (ProcessInstance)it.next();
            if (previousRunningProcess.contains(processInstance)) continue;
            processInstanceUUID = processInstance.getUUID();
            break;
        }
        APITest.assertNotNull(processInstanceUUID);
        int minRunned = 4;
        int expectedRunned = minRunned + 4;
        while (!this.assertOnActivityInstances((QuerierRuntimeAPI)remoteDeployer, processInstanceUUID, minRunned, expectedRunned, 2)) {
            Thread.sleep(500L);
        }
        soapMessageFutureContinue = this.continueProcess(processName);
        soapMessageFutureContinue.get();
        minRunned = expectedRunned + 2;
        expectedRunned = minRunned + 6;
        while (!this.assertOnActivityInstances((QuerierRuntimeAPI)remoteDeployer, processInstanceUUID, minRunned, expectedRunned, 0)) {
            Thread.sleep(500L);
        }
        soapMessageFutureStart.get();
        this.assertOnProcessInstances((QuerierRuntimeAPI)remoteDeployer, initialRunned + 1, 0);
        this.undeploy(processName);
    }

    public boolean assertOnActivityInstances(QuerierRuntimeAPI querierRuntimeAPI, ProcessInstanceUUID processUUID, int minRunned, int expectedRunned, int minRunning) throws OrchestraException {
        int beforeTotalActivity = querierRuntimeAPI.findActivityInstances(processUUID).size();
        Set activityInstanceRunnedSet = querierRuntimeAPI.findActivityInstances(processUUID, ActivityState.FINISHED);
        Set activityInstanceRunningSet = querierRuntimeAPI.findActivityInstances(processUUID, ActivityState.RUNNING);
        int totalActivity = querierRuntimeAPI.findActivityInstances(processUUID).size();
        int runningActivity = activityInstanceRunningSet.size();
        int runnedActivity = activityInstanceRunnedSet.size();
        APITest.assertTrue((runningActivity >= minRunning && runningActivity <= runningActivity + 1 ? 1 : 0) != 0);
        APITest.assertTrue((String)"Expect more activities already run", (runnedActivity >= minRunned ? 1 : 0) != 0);
        APITest.assertTrue((String)"Expect less activities already run", (runnedActivity <= expectedRunned ? 1 : 0) != 0);
        int totalRun = runnedActivity + runningActivity;
        APITest.assertTrue((String)"Issue in find requests", (beforeTotalActivity <= totalRun && totalRun <= totalActivity ? 1 : 0) != 0);
        return expectedRunned == runnedActivity;
    }

    public void assertOnProcessInstances(QuerierRuntimeAPI querierRuntimeAPI, int runned, int running) {
        int beforeTotalInstance = querierRuntimeAPI.findProcessInstances().size();
        Set processInstanceRunnedSet = querierRuntimeAPI.findProcessInstances(ProcessState.FINISHED);
        Set processInstanceRunningSet = querierRuntimeAPI.findProcessInstances(ProcessState.RUNNING);
        int totalInstance = querierRuntimeAPI.findProcessInstances().size();
        int runningInstance = processInstanceRunningSet.size();
        int runnedInstance = processInstanceRunnedSet.size();
        APITest.assertEquals((int)running, (int)runningInstance);
        APITest.assertEquals((int)runned, (int)runnedInstance);
        int totalRun = runnedInstance + runningInstance;
        APITest.assertTrue((beforeTotalInstance <= totalRun && totalRun <= totalInstance ? 1 : 0) != 0);
    }
}

