/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

import javax.xml.namespace.QName;

/**
 * BPELClassLoader.java
 *
 * @author Goulven Le Jeune & Charles Souillard
 * @version $Id:ProcessClassLoader.java 813 2007-10-10 08:21:36Z souillac $
 *
 */
public class ProcessClassLoader extends URLClassLoader {

  private QName processQName;

  public ProcessClassLoader(QName processQName, URL[] urls, ClassLoader parent) {
    super(urls, parent);
    this.processQName = processQName;
  }

  public String getClassPath() {
    String cp = "";
    // add parent classpath before
    if (getParent() != null && getParent() instanceof ProcessClassLoader) {
      cp += ((ProcessClassLoader) getParent()).getClassPath();
    }
    URL[] urls = super.getURLs();
    for (int i = 0; i < urls.length; i++) {
      cp = cp + File.pathSeparator
          + (new File(urls[i].getFile())).getAbsolutePath();
    }
    return cp;
  }

  public String toString() {
    StringBuffer sb = new StringBuffer();
    sb.append(this.getClass().getName());
    sb.append("[");
    sb.append(this.processQName);
    sb.append(", urls=");
    URL[] urls = getURLs();
    for (int u = 0; u < urls.length; u++) {
      sb.append(urls[u]);
      if (u != urls.length - 1) {
        sb.append(";");
      }
    }
    sb.append("]");
    return sb.toString();
  }
}
