package org.ow2.orchestra.axis;

import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.impl.ArchiveUndeployedProcessHandler;
import org.ow2.orchestra.services.handlers.impl.DeleteFinishedInstanceHandler;

/**
 * generates a default environment for running orchestra with axis.
 *
 * @author Guillaume Porcher
 */
public class AxisEnvXmlGenerator extends DefaultEnvXMLGenerator {

  public AxisEnvXmlGenerator() {
    super();
    this.setPublisherType(AxisPublisher.class);
    this.setInvokerType(AxisInvoker.class);
    this.setFinishedInstanceHandlerType(DeleteFinishedInstanceHandler.class,
      ArchiveFinishedInstanceHandler.class);
    this.setUndeployedProcessHandlerType(ArchiveUndeployedProcessHandler.class);
  }

  /**
   * Prints the default environment on standard output.
   *
   * @param args
   */
  public static void main(final String[] args) {
    System.out.println(new AxisEnvXmlGenerator().createEnvironmentXml());
  }
}