/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.example.loanApproval;

import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.AssertionFailedError;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.axis.AxisDeployAction;
import org.ow2.orchestra.axis.test.perf.AxisPerfTestCase;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LoanApprovalTest
extends AxisPerfTestCase {
    private String endpoint = this.getDefaultEndpoint("loanServicePort");
    private String adminServletURL = this.getAdminServerURL();
    private URL approvalUndeployWsdd = LoanApprovalTest.class.getResource("approval/undeploy.wsdd");
    private URL riskUndeployWsdd = LoanApprovalTest.class.getResource("riskAssessment/undeploy.wsdd");

    protected String getProcessName() {
        return "loanService";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/loanApproval/loanService";
    }

    public void deploy() {
        URL approvalDeployWsdd = LoanApprovalTest.class.getResource("approval/deploy.wsdd");
        URL riskDeployWsdd = LoanApprovalTest.class.getResource("riskAssessment/deploy.wsdd");
        AxisDeployAction.deployWS((String)this.adminServletURL, (URL)approvalDeployWsdd);
        AxisDeployAction.deployWS((String)this.adminServletURL, (URL)riskDeployWsdd);
        this.deploy(LoanApprovalTest.class.getResource(this.getProcessName() + ".bpel"), LoanApprovalTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public void undeploy() {
        this.undeploy(new QName(this.getProcessNamespace(), this.getProcessName()));
        AxisDeployAction.deployWS((String)this.adminServletURL, (URL)this.approvalUndeployWsdd);
        AxisDeployAction.deployWS((String)this.adminServletURL, (URL)this.riskUndeployWsdd);
    }

    public long launch() {
        long endTime = -1L;
        int amount = BpelUtil.getRandomInt((long)0L, (int)60000);
        SOAPMessage response = SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", Integer.toString(amount)), (String)this.endpoint);
        endTime = System.currentTimeMillis();
        if (amount >= 30000) {
            this.assertResult(response, "no");
        } else {
            this.assertResult(response, "yes");
        }
        return endTime;
    }

    public void testLoanApproval() {
        try {
            this.deploy();
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "9999"), (String)this.endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "9999"), (String)this.endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Martin", "9999"), (String)this.endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "10000"), (String)this.endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "50000"), (String)this.endpoint), "no");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "30000"), (String)this.endpoint), "no");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "20000"), (String)this.endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Martin", "10000"), (String)this.endpoint), "no");
            this.undeploy();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
    }

    private void assertResult(SOAPMessage response, String expected) {
        if (response != null) {
            SOAPBodyElement operationElement = null;
            try {
                operationElement = this.getSOAPBodyElement(response);
                LoanApprovalTest.assertNotNull((Object)operationElement);
                LoanApprovalTest.assertEquals((String)XmlUtil.toString((Element)operationElement), (String)"request", (String)operationElement.getLocalName());
                List elements = BpelUtil.getElements((Node)operationElement);
                LoanApprovalTest.assertEquals((int)1, (int)elements.size());
                Element partElement = (Element)elements.get(0);
                LoanApprovalTest.assertEquals((String)"accept", (String)partElement.getLocalName());
                List texts = BpelUtil.getTexts((Node)partElement);
                LoanApprovalTest.assertEquals((int)1, (int)texts.size());
                LoanApprovalTest.assertEquals((String)expected, (String)((Text)texts.get(0)).getData());
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException(e);
            }
            catch (AssertionFailedError e) {
                System.err.println("AssertionFailed, operationElement = " + BpelUtil.getNodeAsString((Node)operationElement));
                throw e;
            }
        } else {
            LoanApprovalTest.assertTrue((String)"No return available", (boolean)false);
        }
    }

    private SOAPMessage getRequest(String firstName, String name, String amount) {
        return SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/loanApproval/loanService", (String)("<request xmlns='http://orchestra.ow2.org/loanApproval/common'><firstName>" + firstName + "</firstName>" + "<name>" + name + "</name>" + "<amount>" + amount + "</amount>" + "</request>"));
    }

    public String getAlias() {
        return "axis.loan";
    }
}

