/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.test.querier;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.axis.AxisConfiguration;
import org.ow2.orchestra.axis.test.AxisTestCase;
import org.ow2.orchestra.facade.QuerierRuntimeAPI;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.ProcessInstanceState;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.JMXConfiguration;
import org.ow2.orchestra.util.SOAPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APITest
extends AxisTestCase {
    private static final long TEST_TIMEOUT = 40000L;
    private static final String NAME_SPACE = "http://orchestra.ow2.org/tests/querier/";

    @Override
    public void deploy(String processName) {
        this.deploy(processName, Collections.singletonList(((Object)((Object)this)).getClass().getResource("apitest.wsdl")));
    }

    public void undeploy(String processName) {
        this.undeploy(new QName(NAME_SPACE, processName));
    }

    public Future<SOAPMessage> startProcess(String processName) {
        String operationName = "submit";
        String part = "<submit>bidon</submit>";
        final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/querier/submit", (String)part);
        AxisConfiguration config = AxisConfiguration.getInstance();
        final String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "querierPort";
        FutureTask<SOAPMessage> futureTask = new FutureTask<SOAPMessage>(new Callable<SOAPMessage>(){

            @Override
            public SOAPMessage call() {
                return SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            }
        });
        new Thread(futureTask).start();
        return futureTask;
    }

    public Future<SOAPMessage> continueProcess(String processName) {
        String operationName = "submit";
        String part = "<submit>bidon</submit>";
        final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/querier/submit", (String)part);
        AxisConfiguration config = AxisConfiguration.getInstance();
        final String endpoint = "http://" + config.getHost() + ":" + config.getPort() + "/" + config.getWebappName() + "/" + config.getServletPath() + "/" + "querierContinuePort";
        FutureTask<SOAPMessage> futureTask = new FutureTask<SOAPMessage>(new Callable<SOAPMessage>(){

            @Override
            public SOAPMessage call() {
                return SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            }
        });
        new Thread(futureTask).start();
        return futureTask;
    }

    public void testFindProcessInstances() throws Exception {
        long testStartTime = System.currentTimeMillis();
        String processName = "apitest1";
        this.deploy(processName);
        String jmxServiceUrl = JMXConfiguration.getInstance().getServiceUrl();
        String jmxObjectName = JMXConfiguration.getInstance().getObjectName();
        RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
        int initialRunned = remoteDeployer.findProcessInstances(ProcessInstanceState.FINISHED).size();
        Set previousRunningProcess = remoteDeployer.findProcessInstances(ProcessInstanceState.RUNNING);
        Future<SOAPMessage> soapMessageFutureStart = this.startProcess(processName);
        Future<SOAPMessage> soapMessageFutureContinue = this.continueProcess(processName);
        long timeout = testStartTime + 40000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            APITest.fail((String)"timeout");
        }
        soapMessageFutureContinue.get(timeout, TimeUnit.MILLISECONDS);
        Set runningProcess = remoteDeployer.findProcessInstances(ProcessInstanceState.RUNNING);
        APITest.assertEquals((String)"No new process found", (int)(previousRunningProcess.size() + 1), (int)runningProcess.size());
        Iterator it = runningProcess.iterator();
        ProcessInstanceUUID processInstanceUUID = null;
        while (it.hasNext()) {
            ProcessInstance processInstance = (ProcessInstance)it.next();
            if (previousRunningProcess.contains(processInstance)) continue;
            processInstanceUUID = processInstance.getUUID();
            break;
        }
        APITest.assertNotNull(processInstanceUUID);
        int minRunned = 4;
        int expectedRunned = minRunned + 4;
        while (!this.assertOnActivityInstances((QuerierRuntimeAPI)remoteDeployer, processInstanceUUID, minRunned, expectedRunned, 3, 6)) {
            Thread.sleep(500L);
            if (System.currentTimeMillis() - testStartTime <= 40000L) continue;
            APITest.fail((String)"timeout");
        }
        soapMessageFutureContinue = this.continueProcess(processName);
        timeout = testStartTime + 40000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            APITest.fail((String)"timeout");
        }
        soapMessageFutureContinue.get(timeout, TimeUnit.MILLISECONDS);
        minRunned = expectedRunned + 2;
        expectedRunned = minRunned + 7;
        while (!this.assertOnActivityInstances((QuerierRuntimeAPI)remoteDeployer, processInstanceUUID, minRunned, expectedRunned, 0, 0)) {
            Thread.sleep(500L);
            if (System.currentTimeMillis() - testStartTime <= 40000L) continue;
            APITest.fail((String)"timeout");
        }
        timeout = testStartTime + 40000L - System.currentTimeMillis();
        if (timeout <= 0L) {
            APITest.fail((String)"timeout");
        }
        soapMessageFutureStart.get(timeout, TimeUnit.MILLISECONDS);
        this.assertOnProcessInstances((QuerierRuntimeAPI)remoteDeployer, initialRunned + 1, previousRunningProcess.size());
        this.undeploy(processName);
    }

    public boolean assertOnActivityInstances(QuerierRuntimeAPI querierRuntimeAPI, ProcessInstanceUUID processUUID, int minRunned, int expectedRunned, int minRunning, int expectedRunning) throws OrchestraException {
        Set activityInstanceBeforeTotalSet = querierRuntimeAPI.findActivityInstances(processUUID);
        int beforeTotalActivity = activityInstanceBeforeTotalSet.size();
        if (beforeTotalActivity > expectedRunned + expectedRunning) {
            APITest.fail((String)("Some activities may be duplicated : " + activityInstanceBeforeTotalSet));
        }
        Set activityInstanceRunningSet = querierRuntimeAPI.findActivityInstances(processUUID, ActivityState.RUNNING);
        Set activityInstanceRunnedSet = querierRuntimeAPI.findActivityInstances(processUUID, ActivityState.FINISHED);
        Set activityInstanceTotalSet = querierRuntimeAPI.findActivityInstances(processUUID);
        int totalActivity = activityInstanceTotalSet.size();
        if (totalActivity > expectedRunned + expectedRunning) {
            APITest.fail((String)("Some activities may be duplicated : " + activityInstanceTotalSet));
        }
        int runningActivity = activityInstanceRunningSet.size();
        int runnedActivity = activityInstanceRunnedSet.size();
        APITest.assertTrue((minRunning <= runningActivity ? 1 : 0) != 0);
        APITest.assertTrue((String)"Expect more activities already run", (runnedActivity >= minRunned ? 1 : 0) != 0);
        APITest.assertTrue((String)"Expect less activities already run", (runnedActivity <= expectedRunned ? 1 : 0) != 0);
        int totalRun = this.calculTotalActivities(activityInstanceRunningSet, activityInstanceRunnedSet);
        APITest.assertTrue((String)("Issue in find requests (" + beforeTotalActivity + "," + totalRun + "[" + runnedActivity + "+" + runningActivity + "]" + "," + totalActivity + ")"), (beforeTotalActivity <= totalRun && totalRun <= totalActivity ? 1 : 0) != 0);
        return expectedRunned == runnedActivity;
    }

    private int calculTotalActivities(Set<ActivityInstance> ... activityInstanceSets) {
        HashSet<ActivityInstanceUUID> activityInstanceUUIDSet = new HashSet<ActivityInstanceUUID>();
        for (Set<ActivityInstance> activityInstanceSet : activityInstanceSets) {
            for (ActivityInstance activityInstance : activityInstanceSet) {
                activityInstanceUUIDSet.add(activityInstance.getUUID());
            }
        }
        return activityInstanceUUIDSet.size();
    }

    public void assertOnProcessInstances(QuerierRuntimeAPI querierRuntimeAPI, int runned, int running) {
        int beforeTotalInstance = querierRuntimeAPI.findProcessInstances().size();
        Set processInstanceRunnedSet = querierRuntimeAPI.findProcessInstances(ProcessInstanceState.FINISHED);
        Set processInstanceRunningSet = querierRuntimeAPI.findProcessInstances(ProcessInstanceState.RUNNING);
        int totalInstance = querierRuntimeAPI.findProcessInstances().size();
        int runningInstance = processInstanceRunningSet.size();
        int runnedInstance = processInstanceRunnedSet.size();
        APITest.assertEquals((int)running, (int)runningInstance);
        APITest.assertEquals((int)runned, (int)runnedInstance);
        int totalRun = runnedInstance + runningInstance;
        APITest.assertTrue((beforeTotalInstance <= totalRun && totalRun <= totalInstance ? 1 : 0) != 0);
    }
}

