/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;

import java.net.URL;
import java.net.URLClassLoader;

import javax.xml.namespace.QName;

/**
 * BPELClassLoader.java
 *
 * @author Goulven Le Jeune & Charles Souillard
 * @version $Id:ProcessClassLoader.java 813 2007-10-10 08:21:36Z souillac $
 *
 */
public class ProcessClassLoader extends URLClassLoader {

  private final QName processQName;

  public ProcessClassLoader(final QName processQName, final URL[] urls, final ClassLoader parent) {
    super(urls, parent);
    this.processQName = processQName;
  }

  @Override
  public String toString() {
    final StringBuffer sb = new StringBuffer();
    sb.append(this.getClass().getName());
    sb.append("[");
    sb.append(this.processQName);
    sb.append(", urls=");
    final URL[] urls = this.getURLs();
    for (int u = 0; u < urls.length; u++) {
      sb.append(urls[u]);
      if (u != urls.length - 1) {
        sb.append(";");
      }
    }
    sb.append("]");
    return sb.toString();
  }
}
