/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;

/**
 * ClassLoaderMap.java
 *
 * @author Goulven Le Jeune & Charles Souillard
 * @version $Id:ClassLoaderMap.java 813 2007-10-10 08:21:36Z souillac $
 *
 */
public final class ClassLoaderMap {

  private ClassLoaderMap() {
  }

  private static Map<QName, ProcessClassLoader> classLoaders = new HashMap<QName, ProcessClassLoader>();

  public static ProcessClassLoader getCL(final QName processQName) {
    if (ClassLoaderMap.classLoaders == null) {
      return null;
    }
    final ProcessClassLoader result = ClassLoaderMap.classLoaders
        .get(processQName);
    if (result == null) {
      throw new OrchestraRuntimeException("No process with QName " + processQName
          + " exists in ClassLoaderMap\n", null);
    }
    return result;
  }

  public static void addCL(final QName processQName, final ProcessClassLoader cl) {
    ClassLoaderMap.classLoaders.put(processQName, cl);
  }

  /**
   * @param processQName
   */
  public static void removeCL(final QName processQName) {
    ClassLoaderMap.classLoaders.remove(processQName);
  }

}
