/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;

import java.util.HashMap;
import java.util.Map;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/**
 * ClassLoaderMap.java
 *
 * @author Goulven Le Jeune & Charles Souillard
 * @version $Id:ClassLoaderMap.java 813 2007-10-10 08:21:36Z souillac $
 *
 */
public final class ClassLoaderMap {

  private ClassLoaderMap() {
  }

  private static Map<ProcessDefinitionUUID, ProcessClassLoader> classLoaders =
    new HashMap<ProcessDefinitionUUID, ProcessClassLoader>();

  public static ProcessClassLoader getCL(final ProcessDefinitionUUID processUUID) {
    if (ClassLoaderMap.classLoaders == null) {
      return null;
    }
    final ProcessClassLoader result = ClassLoaderMap.classLoaders
        .get(processUUID);
    if (result == null) {
      throw new OrchestraRuntimeException("No process with UUID " + processUUID
          + " exists in ClassLoaderMap\n", null);
    }
    return result;
  }

  public static void addCL(final ProcessDefinitionUUID processUUID, final ProcessClassLoader cl) {
    ClassLoaderMap.classLoaders.put(processUUID, cl);
  }

  /**
   * @param processUUID
   */
  public static void removeCL(final ProcessDefinitionUUID processUUID) {
    ClassLoaderMap.classLoaders.remove(processUUID);
  }

}
