package org.ow2.orchestra.axis;

import java.io.File;
import java.io.IOException;

import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.impl.ArchiveUndeployedProcessHandler;
import org.ow2.orchestra.services.handlers.impl.DeleteFinishedInstanceHandler;
import org.ow2.orchestra.services.impl.SOAPInvoker;
import org.ow2.orchestra.util.Misc;

/**
 * generates a default environment for running orchestra with axis.
 *
 * @author Guillaume Porcher
 */
public class AxisEnvXmlGenerator extends DefaultEnvXMLGenerator {


  public AxisEnvXmlGenerator(final String hibernateRelativePath, final InstallationType installationType) {
    super(hibernateRelativePath, installationType);
    this.setPublisherType(AxisPublisher.class);
    this.setInvokerType(SOAPInvoker.class);

    if (installationType.hasJournal() && installationType.hasHistory()) {
      this.setFinishedInstanceHandlerType(DeleteFinishedInstanceHandler.class, ArchiveFinishedInstanceHandler.class);
      this.setUndeployedProcessHandlerType(ArchiveUndeployedProcessHandler.class);
    } else {
      this.setFinishedInstanceHandlerType(DeleteFinishedInstanceHandler.class);
    }
  }

  /**
   * Prints the default environment on standard output.
   *
   * @param args
   * @throws IOException
   */
  public static void main(final String[] args) throws IOException {
    if (args.length == 0) {
      System.out.println(new AxisEnvXmlGenerator(null, InstallationType.INTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml());
    } else if (args.length == 1) {
      Misc.write(
          new AxisEnvXmlGenerator(null, InstallationType.INTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(),
          new File(args[0]));
    } else if (args.length == 2) {
      Misc.write(
          new AxisEnvXmlGenerator(args[1], InstallationType.INTERNAL_JOURNAL_WITH_HISTORY).createEnvironmentXml(),
          new File(args[0]));
    } else if (args.length == 3) {
      Misc.write(new AxisEnvXmlGenerator(args[1], InstallationType.valueOf(args[2])).createEnvironmentXml(), new File(args[0]));
    } else {
      throw new OrchestraRuntimeException("Invalid arguments");
    }
  }
}
