/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

import org.apache.axis.AxisProperties;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.axis.transport.http.FilterPrintWriter;

public class OrchestraBaseAxisServlet extends AxisServlet {

  private static final long serialVersionUID = 1177753548162149612L;

  @Override
  public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
    if ("/".equals(request.getPathInfo())) {
      final PrintWriter writer = new FilterPrintWriter(response);
      try {
        this.reportAvailableServices(response, writer, request);
      } finally {
        writer.close();
      }

    }
    super.doGet(request, response);
  }


  @Override
  public void init() throws ServletException {
    // set service path variable
    AxisProperties.setProperty(AxisServlet.INIT_PROPERTY_SERVICES_PATH, "/");
    AxisProperties.setProperty("axis.development.system", "true");
    // AxisServlet init
    super.init();
    // Axis deploys Version and AdminService by default.
    // Undeploy these services as they are not needed.
    this.axisServer.setShouldSaveConfig(false);
    if (this.axisServer.getConfig() instanceof WSDDEngineConfiguration) {
      final WSDDEngineConfiguration config = (WSDDEngineConfiguration) this.axisServer.getConfig();
      config.getDeployment().undeployService(new QName("AdminService"));
      config.getDeployment().undeployService(new QName("Version"));
    }
  }

  @Override
  protected void service(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
    final ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
    try {
      Thread.currentThread().setContextClassLoader(AxisServlet.class.getClassLoader());
      super.service(req, resp);
    } finally {
      Thread.currentThread().setContextClassLoader(oldClassLoader);
    }
  }
}
