/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.MsgProvider;

/**
 * BPELMsgProvider.java
 *
 * @author Goulven Le Jeune & Charles Souillard
 * @version $Id:ProcessMsgProvider.java 813 2007-10-10 08:21:36Z souillac $
 *
 */
public class ProcessMsgProvider extends MsgProvider {

  private static final long serialVersionUID = 5240751552526750450L;

  private static final String METHOD_BODYARRAY = "soapbodyelement";

  private static final String METHOD_ELEMENTARRAY = "element";

  private static final String METHOD_DOCUMENT = "document";


  protected void setOperationStyle(final MessageContext msgContext) {

    final OperationDesc operation = msgContext.getOperation();
    if (operation == null || operation.getMessageOperationStyle() > -1) {
      return;
    }
    int methodType = operation.getMessageOperationStyle();
    final String methodSignature = operation.getMethod().toString().toLowerCase();
    if (methodSignature.indexOf(ProcessMsgProvider.METHOD_BODYARRAY) != -1) {
      methodType = OperationDesc.MSG_METHOD_BODYARRAY;
    } else if (methodSignature.indexOf(ProcessMsgProvider.METHOD_ELEMENTARRAY) != -1) {
      methodType = OperationDesc.MSG_METHOD_ELEMENTARRAY;
    } else if (methodSignature.indexOf(ProcessMsgProvider.METHOD_DOCUMENT) != -1) {
      methodType = OperationDesc.MSG_METHOD_DOCUMENT;
    } else {
      methodType = OperationDesc.MSG_METHOD_SOAPENVELOPE;
    }
    operation.setMessageOperationStyle(methodType);
  }

  @Override
  public void invoke(final MessageContext msgContext) throws AxisFault {
    // Make sure that the method style is correctly set (This does not appear to
    // be handled by default)
    this.setOperationStyle(msgContext);
    // Set the msgClassLoader
    final String endpointName = msgContext.getService().getName();
    final WebServiceClassLoader cl = ClassLoaderMap.getCL(endpointName);
    msgContext.setClassLoader(cl);

    final ClassLoader old = Thread.currentThread().getContextClassLoader();
    try {
      Thread.currentThread().setContextClassLoader(cl.getOrchestraClassLoader());
      super.invoke(msgContext);
    } finally {
      Thread.currentThread().setContextClassLoader(old);
    }
  }


  @Override
  public void initServiceDesc(final SOAPService service, final MessageContext msgContext) throws AxisFault {
    // Set the message classloader
    final String endpointName = service.getName();
    final ClassLoader cl = ClassLoaderMap.getCL(endpointName);
    if (msgContext != null) {
      msgContext.setClassLoader(cl);
    }
    super.initServiceDesc(service, msgContext);
  }
}
