package org.ow2.orchestra.axis;

import java.util.List;
import java.util.Properties;

import javax.servlet.Servlet;
import javax.wsdl.Service;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.services.itf.HttpPublisher;

/**
 * AxisServicePublisher.java. Implementation of the service publisher with axis.
 *
 * @author Charles Souillard
 *
 * Created on : Jun 26, 2007
 */
public class AxisPublisher extends PublisherImpl implements HttpPublisher {

  @Override
  public void publishServices(final BpelProcess bpelProcess, final Environment environment) {
    super.publishServices(bpelProcess, environment);
    final AxisDeployer axisDeployer = new AxisDeployer(bpelProcess, this);
    final List<Service> services = this.getServices(bpelProcess);
    if (services != null) {
      axisDeployer.deploy(services);
    }
  }

  @Override
  public void unpublishServices(final BpelProcess bpelProcess, final Environment environment) {
    final AxisDeployer axisDeployer = new AxisDeployer(bpelProcess, this);
    final List<Service> services = this.getServices(bpelProcess);
    if (services != null) {
      axisDeployer.undeploy(services);
    }
    super.unpublishServices(bpelProcess, environment);
  }

  public Servlet getPublisherServlet(final Properties orchestraProperties) {
    return new OrchestraBaseAxisServlet();
  }
}
