/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.axis;

import java.util.HashMap;
import java.util.Map;

import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;

/**
 * ClassLoaderMap.java
 *
 * @author Goulven Le Jeune & Charles Souillard
 * @version $Id:ClassLoaderMap.java 813 2007-10-10 08:21:36Z souillac $
 *
 */
public final class ClassLoaderMap {

  private ClassLoaderMap() {
  }

  private static Map<String, WebServiceClassLoader> classLoaders =
    new HashMap<String, WebServiceClassLoader>();

  public static WebServiceClassLoader getCL(final String endpointName) {
    if (ClassLoaderMap.classLoaders == null) {
      return null;
    }
    final WebServiceClassLoader result = ClassLoaderMap.classLoaders.get(endpointName);
    if (result == null) {
      throw new OrchestraRuntimeException("No service with url " + endpointName
          + " exists in ClassLoaderMap");
    }
    return result;
  }

  public static void addCL(final String endpointName, final WebServiceClassLoader cl) {
    ClassLoaderMap.classLoaders.put(endpointName, cl);
  }

  /**
   * @param processUUID
   */
  public static void removeCL(final String endpointName) {
    ClassLoaderMap.classLoaders.remove(endpointName);
  }

}
