/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.management.ServiceAdmin;
import org.apache.axis.server.AxisServer;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.MessageCarrierImpl;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingService;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.BpelSOAPUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AxisWSImpl {
    private static Logger log = Logger.getLogger(AxisWSImpl.class.getName());
    private final QName processQName;
    private final QName portTypeQName;
    private final Map<String, Operation> operations = new HashMap<String, Operation>();
    private final AxisServer engine;

    public AxisWSImpl(QName processQName, QName portTypeQName) {
        this.processQName = processQName;
        this.portTypeQName = portTypeQName;
        try {
            this.engine = ServiceAdmin.getEngine();
        }
        catch (AxisFault e) {
            throw new OrchestraRuntimeException("Exception during Web service deployment.", (Throwable)e);
        }
    }

    public Operation getOperation(String operationName) {
        if (!this.operations.containsKey(operationName)) {
            CommandService commandService = (CommandService)this.engine.getOption(CommandService.class.getName());
            Operation op = (Operation)commandService.execute((Command)new GetOperationCommand(this.processQName, this.portTypeQName, operationName));
            this.operations.put(operationName, op);
        }
        return this.operations.get(operationName);
    }

    public Element[] call(Element[] bodies, String operationName, String operationStyle, boolean lock) throws AxisFault {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Entering WS Implementation, process = " + this.processQName + ", PT = " + this.portTypeQName + ", op = " + operationName + ", opStyle = " + operationStyle);
            for (Element body : bodies) {
                log.fine("body = " + body);
            }
        }
        Element[] elementsReturned = null;
        MessageVariable incomingMessage = null;
        Operation operation = this.getOperation(operationName);
        Message inputMessage = operation.getInput().getMessage();
        incomingMessage = operationStyle.equals("document") ? BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement(inputMessage.getParts().values(), (Element)bodies[0]) : BpelSOAPUtil.buildMessageFromRpcSOAPBodyElement(inputMessage.getParts().values(), (Element)bodies[0]);
        if (log.isLoggable(Level.FINE)) {
            log.fine("incomingMessage = " + incomingMessage);
        }
        MessageCarrierImpl messageCarrier = null;
        BpelExecution instance = null;
        if (operation.getOutput() != null) {
            messageCarrier = new MessageCarrierImpl();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Doing call to receiver, messageCarrier = " + messageCarrier);
        }
        OperationKey operationKey = new OperationKey(this.processQName, this.portTypeQName, operationName);
        CommandService commandService = (CommandService)this.engine.getOption(CommandService.class.getName());
        instance = ReceivingService.handle((MessageVariable)incomingMessage, (OperationKey)operationKey, (MessageCarrier)messageCarrier, (boolean)lock, (CommandService)commandService);
        if (log.isLoggable(Level.FINE)) {
            log.fine("call to receiver done. Instance = " + instance);
        }
        if (operation.getOutput() != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("This operation has an output, waiting for messageCarrier...");
            }
            MessageVariable responseMessage = messageCarrier.getMessage();
            QName faultQName = messageCarrier.getFaultQName();
            if (faultQName != null && faultQName.getNamespaceURI().equals(this.portTypeQName.getNamespaceURI())) {
                List<Part> parts = AxisWSImpl.getFaultParts(operation, faultQName.getLocalPart());
                elementsReturned = new Element[parts.size()];
                int i = 0;
                for (Part part : parts) {
                    elementsReturned[i] = responseMessage.getPartValue(part.getName());
                    ++i;
                }
                AxisFault fault = new AxisFault();
                fault.setFaultCode(faultQName);
                fault.setFaultDetail(elementsReturned);
                throw fault;
            }
            if (operationStyle.equals("document")) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("This operation is using 'document' style.");
                }
                List<Part> parts = AxisWSImpl.getOutputParts(operation);
                elementsReturned = new Element[parts.size()];
                int i = 0;
                for (Part part : parts) {
                    elementsReturned[i] = responseMessage.getPartValue(part.getName());
                    ++i;
                }
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("This operation is using 'rpc' style.");
                }
                Document rpcDocument = BpelSOAPUtil.buildRpcDocument((MessageVariable)responseMessage, (String)(operationKey.getOperationName() + "Response"));
                elementsReturned = new Element[]{rpcDocument.getDocumentElement()};
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("elementsReturned = " + Arrays.toString(elementsReturned));
        }
        return elementsReturned;
    }

    private static Operation getOperation(PortType portType, String operationName) {
        List operations = portType.getOperations();
        for (Operation operation : operations) {
            if (!operation.getName().equals(operationName)) continue;
            return operation;
        }
        return null;
    }

    private static List<Part> getOutputParts(Operation operation) {
        Output output = operation.getOutput();
        if (output != null) {
            return AxisWSImpl.getMessageParts(output.getMessage());
        }
        return new ArrayList<Part>();
    }

    private static List<Part> getFaultParts(Operation operation, String faultName) {
        Fault output = operation.getFault(faultName);
        if (output != null) {
            return AxisWSImpl.getMessageParts(output.getMessage());
        }
        return new ArrayList<Part>();
    }

    private static List<Part> getMessageParts(Message message) {
        Map partMap = message.getParts();
        Collection parts = partMap.values();
        return new ArrayList<Part>(parts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GetOperationCommand
    implements Command<Operation> {
        private static final long serialVersionUID = 5451904601397581112L;
        private final QName processQName;
        private final QName portTypeQName;
        private final String operationName;

        public GetOperationCommand(QName processQName, QName portTypeQName, String operationName) {
            this.processQName = processQName;
            this.portTypeQName = portTypeQName;
            this.operationName = operationName;
        }

        public Operation execute(Environment environment) {
            Repository repository = (Repository)environment.get(Repository.class);
            List bpelProcesses = repository.getProcesses(this.processQName);
            for (BpelProcess bpelProcess : bpelProcesses) {
                Operation op;
                WsdlsInfos wsdlsInfos = bpelProcess.getWsdlInfos();
                PortType portType = wsdlsInfos.getPortType(this.portTypeQName);
                if (portType == null || (op = AxisWSImpl.getOperation(portType, this.operationName)) == null) continue;
                return op;
            }
            return null;
        }
    }
}

