package org.ow2.orchestra.cxf.example.loanApprovalCamel;

import org.apache.camel.Handler;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import java.math.BigInteger;

/**
 * Implementation of the Approval Web Service.
 *
 * Used in a route with a CXF endpoint. The CXF endpoint parses the SOAP message
 * and creates an object array with the web service parameters. The CXF endpoint creates
 * reply SOAP message from the string output.
 *
 * The method annotated with {@Handler} is called by Camel.
 *
 * @author Guillaume Porcher
 *
 */
@WebService(targetNamespace = "http://orchestra.ow2.org/loanApproval/approval", name = "approvalPT")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public class ApprovalBindingImpl implements ApprovalPT {
  @WebResult(name = "accept", targetNamespace = "http://orchestra.ow2.org/loanApproval/approval", partName = "accept")
  @WebMethod(action = "http://orchestra.ow2.org/loanApproval/approval")
  public String approve(
          @WebParam(partName = "firstName", name = "firstName") java.lang.String firstName,
          @WebParam(partName = "name", name = "name") java.lang.String name,
          @WebParam(partName = "amount", name = "amount") java.math.BigInteger amount) {
    if ("Dupont".equals(name) || "McDonalds".equals(name)) {
      if (amount.intValue() < 30000) {
        return "yes";
      }
      return "no";
    } else if ("Kent".equals(name) || "Martin".equals(name)) {
      if (amount.intValue() < 10000) {
        return "yes";
      }
      return "no";
    } else if (amount.intValue() < 50000) {
      return "yes";
    }
    return "no";
  }

  @Handler
  public java.lang.String approve(final Object[] params) {
    return this.approve((String) params[0], (String) params[1], (BigInteger) params[2]);
  }
}
