/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.io.IOException;
import java.net.URL;
import junit.framework.Assert;
import org.ow2.orchestra.facade.QueryDefinitionAPI;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.jmx.QueryDefinitionAPIImpl;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.Misc;

public class GetProcessResourceTest
extends BpelTestCase {
    private static final String PROCESS_NAME = "orderingService";
    private static final String NAME_SPACE = "http://orchestra.ow2.org/demos/orderingService";

    public GetProcessResourceTest() {
        super(NAME_SPACE, PROCESS_NAME, BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testGetProcessResourceBadUUID() throws Exception {
        QueryDefinitionAPIImpl queryDefinitionAPI = new QueryDefinitionAPIImpl(this.getEnvironmentFactory());
        try {
            queryDefinitionAPI.getProcessResource(new ProcessDefinitionUUID("This is a fake UUID"), "resourceName");
            Assert.fail((String)"expecting exception");
        }
        catch (ProcessNotFoundException processNotFoundException) {
            // empty catch block
        }
    }

    public void testGetProcessResourceMissingResource() throws Exception {
        QueryDefinitionAPIImpl queryDefinitionAPI = new QueryDefinitionAPIImpl(this.getEnvironmentFactory());
        ProcessDefinition processDefinition = this.deployBar("orderingService.bpel", "orderingService.wsdl");
        byte[] actualContent = queryDefinitionAPI.getProcessResource(processDefinition.getUUID(), "resourceName");
        Assert.assertNull((Object)actualContent);
        this.undeploy();
    }

    public void testGetProcessResource() throws Exception {
        QueryDefinitionAPIImpl queryDefinitionAPI = new QueryDefinitionAPIImpl(this.getEnvironmentFactory());
        ProcessDefinition processDefinition = this.deployBar("orderingService.bpel", "orderingService.wsdl");
        Assert.assertEquals((int)2, (int)processDefinition.getProcessResourceNames().size());
        this.checkResource((QueryDefinitionAPI)queryDefinitionAPI, processDefinition, "orderingService.bpel");
        this.checkResource((QueryDefinitionAPI)queryDefinitionAPI, processDefinition, "orderingService.wsdl");
        this.undeploy();
    }

    private void checkResource(QueryDefinitionAPI queryDefinitionAPI, ProcessDefinition processDefinition, String resourceName) throws ProcessNotFoundException, IOException {
        Assert.assertTrue((String)("resource " + resourceName + " not found !"), (boolean)processDefinition.getProcessResourceNames().contains(resourceName));
        byte[] actualContent = queryDefinitionAPI.getProcessResource(processDefinition.getUUID(), resourceName);
        byte[] expectedContent = Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource(resourceName));
        Assert.assertEquals((String)new String(expectedContent), (String)new String(actualContent));
    }
}

