/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.parsing.copyUndefinedVar;

import org.ow2.orchestra.facade.exception.ParsingException;
import org.ow2.orchestra.test.BpelTestCase;

public class CopyUndefinedVarTest
extends BpelTestCase {
    public CopyUndefinedVarTest() {
        super("http://example.com/copyUndefinedVar", "copyUndefinedVar");
    }

    public void testCopyUndefinedToVar() {
        try {
            this.deploy();
            CopyUndefinedVarTest.fail((String)"Deploying a process with a copy referencing an undefined variable should rise a parsing exception");
        }
        catch (ParsingException e) {
            CopyUndefinedVarTest.assertFalse((String)"Null pointer exception encountered", (boolean)e.getMessage().contains("java.lang.NullPointerException"));
            CopyUndefinedVarTest.assertTrue((boolean)e.getMessage().contains("Undefined variable referenced in copy element: to"));
        }
    }

    public void testCopyUndefinedFromVar() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "2.bpel"));
            CopyUndefinedVarTest.fail((String)"Deploying a process with a copy referencing an undefined variable should rise a parsing exception");
        }
        catch (ParsingException e) {
            CopyUndefinedVarTest.assertFalse((String)"Null pointer exception encountered", (boolean)e.getMessage().contains("java.lang.NullPointerException"));
            CopyUndefinedVarTest.assertTrue((boolean)e.getMessage().contains("Undefined variable referenced in copy element: to"));
        }
    }

    public void testCopyUndefinedToPartVar() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "3.bpel"));
            CopyUndefinedVarTest.fail((String)"Deploying a process with a copy referencing an undefined message part should rise a parsing exception");
        }
        catch (ParsingException e) {
            CopyUndefinedVarTest.assertFalse((String)"Null pointer exception encountered", (boolean)e.getMessage().contains("java.lang.NullPointerException"));
            CopyUndefinedVarTest.assertTrue((boolean)e.getMessage().contains("Undefined message part referenced in copy element: invalid"));
        }
    }

    public void testCopyUndefinedFromPartVar() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "4.bpel"));
            CopyUndefinedVarTest.fail((String)"Deploying a process with a copy referencing an undefined message part should rise a parsing exception");
        }
        catch (ParsingException e) {
            CopyUndefinedVarTest.assertFalse((String)"Null pointer exception encountered", (boolean)e.getMessage().contains("java.lang.NullPointerException"));
            CopyUndefinedVarTest.assertTrue((boolean)e.getMessage().contains("Undefined message part referenced in copy element: invalid"));
        }
    }
}

