/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.test.parsing;

import junit.framework.Assert;
import org.ow2.orchestra.b4p.test.Bpel4PeopleTestCase;

public class PeopleActivityBindingTest
extends Bpel4PeopleTestCase {
    public PeopleActivityBindingTest() {
        super("http://orchestra.ow2.org/PeopleActivityBindingTest", "PeopleActivityBindingTest");
    }

    public void testPeopleActivity_NoInputVar() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "_NoInputVar.bpel"));
            PeopleActivityBindingTest.fail((String)"No input variable in People activity should throw exception");
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)e.getMessage().contains("java.lang.NullPointerException"));
            Assert.assertTrue((String)"Parsing exception No input variable ", (boolean)e.getMessage().contains("has specified both an inputVariable and a toPart"));
        }
    }

    public void testPeopleActivity_NoTask() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "_NoTask.bpel"));
            PeopleActivityBindingTest.fail((String)"No task defined in People activity should throw exception");
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)e.getMessage().contains("java.lang.NullPointerException"));
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("b4p:peopleActivity"));
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("SAXParseException"));
        }
    }

    public void testPeopleActivity_UnknownAttribute() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "_UnknownAttribute.bpel"));
            PeopleActivityBindingTest.fail((String)"Unknown attribute defined in People activity should throw exception");
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)e.getMessage().contains("java.lang.NullPointerException"));
            Assert.assertTrue((String)"Unknowns attribute used in line 49 column 43 ", (boolean)e.getMessage().contains("[line=49 column=43]"));
        }
    }

    public void testPeopleActivity_UnknownElement() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "_UnknownElement.bpel"));
            PeopleActivityBindingTest.fail((String)"Unknown element defined in People activity should throw exception");
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)e.getMessage().contains("java.lang.NullPointerException"));
            Assert.assertTrue((String)"Unknowns element used in line 52 column 22 ", (boolean)e.getMessage().contains("[line=52 column=22]"));
        }
    }

    public void testPeopleActivity_Ok() {
        try {
            this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "_Ok.bpel"));
            this.undeploy();
        }
        catch (Exception e) {
            PeopleActivityBindingTest.fail((String)"No Exception for this test");
        }
    }
}

