/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.orchestra.b4p.TaskDefinition;
import org.ow2.orchestra.b4p.TaskRepository;
import org.ow2.orchestra.b4p.TaskRuntime;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTaskRepository
implements TaskRepository {
    private Map<String, TaskRuntime> taskRuntimeMap = new HashMap<String, TaskRuntime>();
    private Map<ActivityDefinitionUUID, TaskDefinition> taskDefinitionMap = new HashMap<ActivityDefinitionUUID, TaskDefinition>();

    public TaskRuntime getTaskRuntime(String taskId) {
        return this.taskRuntimeMap.get(taskId);
    }

    public void addTaskRuntime(TaskRuntime taskRuntime) {
        this.taskRuntimeMap.put(taskRuntime.getId(), taskRuntime);
    }

    public TaskRuntime removeTaskRuntime(String taskId) {
        return this.taskRuntimeMap.remove(taskId);
    }

    public TaskDefinition getTaskDefinition(ActivityDefinitionUUID name) {
        return this.taskDefinitionMap.get(name);
    }

    public void addTaskDefinition(TaskDefinition taskDefinition) {
        this.taskDefinitionMap.put(taskDefinition.getActivityDefinitionUUID(), taskDefinition);
    }

    public List<TaskRuntime> getTaskRuntimes(String user) {
        ArrayList<TaskRuntime> result = new ArrayList<TaskRuntime>();
        for (TaskRuntime t : this.taskRuntimeMap.values()) {
            if (t.getTaskDefinition().isNotification()) {
                if (!t.getNotificationRecipients().getUsers().getUser().contains(user)) continue;
                result.add(t);
                continue;
            }
            if (!user.equals(t.getActualOwner()) && (t.getActualOwner() != null || t.getPotentialOwners() == null || !t.getPotentialOwners().getUsers().getUser().contains(user))) continue;
            result.add(t);
        }
        return result;
    }
}

