/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p;

import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Message;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.ow2.orchestra.b4p.TaskDefinition;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.ws_ht.TOrganizationalEntity;
import org.ow2.orchestra.ws_ht.TUserlist;
import org.ow2.orchestra.ws_ht.api.TStatus;
import org.ow2.orchestra.ws_ht.api.TTask;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRuntime
extends TTask {
    public static final String TASK_TYPE = "TASK";
    public static final String NOTIFICATION_TYPE = "NOTIFICATION";
    public static final String TASK_VARIABLE_NAME = "TASK";
    protected long dbid;
    private BpelExecution bpelExecution;
    private TaskDefinition taskDefinition;
    private MessageVariable inputMessage;
    private MessageVariable outputMessage;
    private Map<String, String> presentationDescriptions = new HashMap<String, String>();
    private TStatus resumeState;

    public TaskRuntime() {
    }

    public TaskRuntime(BpelExecution bpelExecution, TaskDefinition taskDefinition, MessageVariable inputMessage) {
        bpelExecution.createVariable("TASK", (Object)this);
        this.taskDefinition = taskDefinition;
        this.id = bpelExecution.getActivityInstanceUUID().toString();
        if (taskDefinition.isNotification()) {
            this.taskType = NOTIFICATION_TYPE;
        } else {
            this.taskType = "TASK";
            this.bpelExecution = bpelExecution;
            Message outputWsdlMessage = bpelExecution.getProcessDefinition().getWsdlInfos().getMessage(taskDefinition.getOutputMessageType());
            this.outputMessage = new MessageVariable(outputWsdlMessage);
        }
        this.inputMessage = inputMessage;
        this.status = TStatus.CREATED;
        Object priorityValue = taskDefinition.getPriorityExpression().getValue(bpelExecution);
        this.priority = priorityValue instanceof Number ? BigInteger.valueOf(((Number)priorityValue).longValue()) : new BigInteger(priorityValue.toString());
        TOrganizationalEntity taskInitiatorOrganizationalEntity = this.getOrganizationalEntity(taskDefinition.getTaskInitiator(), bpelExecution);
        if (taskInitiatorOrganizationalEntity != null) {
            this.taskInitiator = (String)taskInitiatorOrganizationalEntity.getUsers().getUser().get(0);
        }
        this.potentialOwners = this.getOrganizationalEntity(taskDefinition.getPotentialOwners(), bpelExecution);
        this.businessAdministrators = this.getOrganizationalEntity(taskDefinition.getBusinessAdministrators(), bpelExecution);
        this.taskStakeholders = this.getOrganizationalEntity(taskDefinition.getTaskStakeHolders(), bpelExecution);
        this.notificationRecipients = this.getOrganizationalEntity(taskDefinition.getNotificationRecipients(), bpelExecution);
        this.name = this.taskDefinition.getQName();
        this.setCreatedOn(new Date());
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        for (Map.Entry<String, From> entry : taskDefinition.getPresentationParameters().entrySet()) {
            Object value = entry.getValue().getValue(bpelExecution);
            parameterValues.put(entry.getKey(), value.toString());
        }
        this.setPresentationName(taskDefinition.getPresentationName());
        if (this.taskDefinition.getPresentationSubject() != null) {
            this.setPresentationSubject(this.replaceParameters(taskDefinition.getPresentationSubject(), parameterValues));
        }
        if (!this.taskDefinition.getPresentationDescriptions().isEmpty()) {
            for (Map.Entry<String, Object> entry : taskDefinition.getPresentationDescriptions().entrySet()) {
                this.presentationDescriptions.put(entry.getKey(), this.replaceParameters((String)entry.getValue(), parameterValues));
            }
        }
        bpelExecution.removeVariable("TASK");
    }

    private String replaceParameters(String original, Map<String, String> parameterValues) {
        String result = original;
        for (Map.Entry<String, String> parameter : parameterValues.entrySet()) {
            result = result.replaceAll("\\{\\$" + parameter.getKey() + "\\}", parameter.getValue());
        }
        return result;
    }

    private TOrganizationalEntity getOrganizationalEntity(From from, BpelExecution bpelExecution) {
        if (from == null) {
            return null;
        }
        Object value = from.getValue(bpelExecution);
        if (value instanceof Element) {
            try {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TOrganizationalEntity.class});
                Unmarshaller um = ctx.createUnmarshaller();
                JAXBElement obj = um.unmarshal((Node)((Element)value), TOrganizationalEntity.class);
                return (TOrganizationalEntity)obj.getValue();
            }
            catch (JAXBException e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }
        if (value instanceof String) {
            TOrganizationalEntity org = new TOrganizationalEntity();
            TUserlist userlist = new TUserlist();
            org.setUsers(userlist);
            org.getUsers().getUser().add((String)value);
            return org;
        }
        throw new OrchestraRuntimeException("Unknown organizationalEntity value: " + value);
    }

    public BpelExecution getBpelExecution() {
        return this.bpelExecution;
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setInputMessage(MessageVariable inputMessage) {
        this.inputMessage = inputMessage;
    }

    public MessageVariable getInputMessage() {
        return this.inputMessage;
    }

    public void setBpelExecution(BpelExecution bpelExecution) {
        this.bpelExecution = bpelExecution;
    }

    public TStatus getResumeState() {
        return this.resumeState;
    }

    public void setResumeState(TStatus resumeState) {
        this.resumeState = resumeState;
    }

    public void setOutputMessage(MessageVariable outputMessage) {
        this.outputMessage = outputMessage;
    }

    public MessageVariable getOutputMessage() {
        return this.outputMessage;
    }

    public Map<String, String> getPresentationDescriptions() {
        return this.presentationDescriptions;
    }
}

