/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.b4p.TaskDefinition;
import org.ow2.orchestra.b4p.TaskRepository;
import org.ow2.orchestra.b4p.TaskRuntime;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.persistence.db.hibernate.HibernateDbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTaskRepository
implements TaskRepository {
    protected HibernateDbSession dbSession;

    public DbTaskRepository(HibernateDbSession dbSession) {
        this.dbSession = dbSession;
    }

    @Override
    public TaskRuntime getTaskRuntime(String taskId) {
        return (TaskRuntime)((Object)this.getDbSession().getSession().createQuery("from " + TaskRuntime.class.getName() + " as task where task.id='" + taskId + "'").uniqueResult());
    }

    @Override
    public void addTaskRuntime(TaskRuntime taskRuntime) {
        this.getDbSession().save((Object)taskRuntime);
    }

    @Override
    public TaskRuntime removeTaskRuntime(String taskId) {
        TaskRuntime t = this.getTaskRuntime(taskId);
        if (t != null) {
            this.getDbSession().delete((Object)t);
        }
        return t;
    }

    @Override
    public TaskDefinition getTaskDefinition(ActivityDefinitionUUID name) {
        return (TaskDefinition)this.getDbSession().getSession().createQuery("from " + TaskDefinition.class.getName() + " as task where task.activityDefinitionUUID.value='" + name + "'").uniqueResult();
    }

    @Override
    public void addTaskDefinition(TaskDefinition taskDefinition) {
        this.getDbSession().save((Object)taskDefinition);
    }

    @Override
    public List<TaskRuntime> getTaskRuntimes(String user) {
        List taskRuntimes = this.getDbSession().getSession().createCriteria(TaskRuntime.class).list();
        ArrayList<TaskRuntime> result = new ArrayList<TaskRuntime>();
        for (TaskRuntime t : taskRuntimes) {
            if (t.getTaskDefinition().isNotification()) {
                if (!t.getNotificationRecipients().getUsers().getUser().contains(user)) continue;
                result.add(t);
                continue;
            }
            if ((user == null || !user.equals(t.getActualOwner())) && (t.getActualOwner() != null || t.getPotentialOwners() == null || !t.getPotentialOwners().getUsers().getUser().contains(user))) continue;
            result.add(t);
        }
        return result;
    }

    public HibernateDbSession getDbSession() {
        return this.dbSession;
    }

    public void setDbSession(HibernateDbSession dbSession) {
        this.dbSession = dbSession;
    }
}

