/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.ow2.orchestra.b4p.TaskDefinition;
import org.ow2.orchestra.b4p.TaskRepository;
import org.ow2.orchestra.b4p.TaskRuntime;
import org.ow2.orchestra.b4p.definition.PeopleActivity;
import org.ow2.orchestra.b4p.humantaskapi.HumanTaskAPI;
import org.ow2.orchestra.b4p.ws.TaskOperationsImpl;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.facade.exception.DeploymentException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.ws_ht.TNotification;
import org.ow2.orchestra.ws_ht.TTask;
import org.ow2.orchestra.ws_ht.api.TStatus;
import org.ow2.orchestra.ws_ht.api.wsdl.TaskOperations;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HumanTaskAPIImpl
implements HumanTaskAPI {
    private EnvironmentFactory environmentFactory;

    public HumanTaskAPIImpl(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    public QName deployTask(BpelProcess process, PeopleActivity peopleActivity, String targetNamespace, ActivityDefinitionUUID activityDefinitionUUID) {
        TaskDefinition taskDefinition;
        block4: {
            Document taskDocument = peopleActivity.getTaskDocument();
            taskDefinition = null;
            try {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TTask.class});
                Unmarshaller um = ctx.createUnmarshaller();
                JAXBElement obj = (JAXBElement)um.unmarshal((Node)taskDocument);
                if (obj.getDeclaredType().equals(TTask.class)) {
                    TTask task = (TTask)obj.getValue();
                    taskDefinition = new TaskDefinition(task, activityDefinitionUUID, process);
                    break block4;
                }
                if (obj.getDeclaredType().equals(TNotification.class)) {
                    TNotification notification = (TNotification)obj.getValue();
                    taskDefinition = new TaskDefinition(notification, activityDefinitionUUID, process);
                    break block4;
                }
                throw new DeploymentException("Unknown task type " + obj.getDeclaredType().getName());
            }
            catch (JAXBException e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }
        TaskRepository taskRepository = (TaskRepository)Environment.getFromCurrent(TaskRepository.class);
        taskRepository.addTaskDefinition(taskDefinition);
        return taskDefinition.getQName();
    }

    public void undeployTask(ActivityDefinitionUUID activityDefinitionUUID) {
    }

    public void createTaskInstance(ActivityDefinitionUUID activityDefinitionUUID, MessageVariable inputMessage, BpelExecution execution, Date activationTime, Date expirationTime) {
        TaskRepository taskRepository = (TaskRepository)Environment.getFromCurrent(TaskRepository.class);
        TaskDefinition taskDefinition = taskRepository.getTaskDefinition(activityDefinitionUUID);
        TaskRuntime taskRuntime = new TaskRuntime(execution, taskDefinition, inputMessage);
        taskRepository.addTaskRuntime(taskRuntime);
        if (activationTime == null || activationTime.before(new Date())) {
            taskRuntime.setStatus(TStatus.READY);
        }
    }

    public void createTaskOperationsWebService(Bus bus) {
        TaskOperationsImpl taskOperationsImpl = new TaskOperationsImpl();
        taskOperationsImpl.setContext((WebServiceContext)new WebServiceContextImpl());
        Class<TaskOperations> clazz = TaskOperations.class;
        TaskOperationsEnvironmentInterceptor interceptor = new TaskOperationsEnvironmentInterceptor(this.environmentFactory, taskOperationsImpl);
        TaskOperations taskOperations = (TaskOperations)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)interceptor);
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        svrFactory.setBus(bus);
        svrFactory.setServiceClass(TaskOperations.class);
        svrFactory.setAddress("/taskOperations");
        svrFactory.setServiceBean((Object)taskOperations);
        svrFactory.getInInterceptors().add(new LoggingInInterceptor());
        svrFactory.getOutInterceptors().add(new LoggingOutInterceptor());
        svrFactory.create();
    }

    public static class TaskOperationsEnvironmentInterceptor
    implements InvocationHandler {
        private final CommandService commandService;
        private final TaskOperationsImpl taskOperations;

        public TaskOperationsEnvironmentInterceptor(EnvironmentFactory environmentFactory, TaskOperationsImpl taskOperations) {
            this.commandService = (CommandService)environmentFactory.get(CommandService.class);
            this.taskOperations = taskOperations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                Object object = this.commandService.execute((Command)new Command<Object>(){

                    public Object execute(Environment environment) {
                        try {
                            TaskOperationsEnvironmentInterceptor.this.taskOperations.setTaskRepository((TaskRepository)environment.get(TaskRepository.class));
                            return method.invoke((Object)TaskOperationsEnvironmentInterceptor.this.taskOperations, args);
                        }
                        catch (Exception e) {
                            throw new OrchestraRuntimeException((Throwable)e);
                        }
                    }
                });
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }
}

