/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.definition.element.Literal;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.ws_ht.TDeadlines;
import org.ow2.orchestra.ws_ht.TDelegation;
import org.ow2.orchestra.ws_ht.TDescription;
import org.ow2.orchestra.ws_ht.TExpression;
import org.ow2.orchestra.ws_ht.TFrom;
import org.ow2.orchestra.ws_ht.TGenericHumanRole;
import org.ow2.orchestra.ws_ht.TNotification;
import org.ow2.orchestra.ws_ht.TPeopleAssignments;
import org.ow2.orchestra.ws_ht.TPresentationElements;
import org.ow2.orchestra.ws_ht.TPresentationParameter;
import org.ow2.orchestra.ws_ht.TPriority;
import org.ow2.orchestra.ws_ht.TQuery;
import org.ow2.orchestra.ws_ht.TRenderings;
import org.ow2.orchestra.ws_ht.TTask;
import org.ow2.orchestra.ws_ht.TText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDefinition {
    protected long dbid;
    protected boolean isNotification;
    protected QName outputMessageType;
    protected ActivityDefinitionUUID activityDefinitionUUID;
    protected String name;
    protected TPriority priority;
    protected TPresentationElements presentationElements;
    protected TRenderings renderings;
    protected TDelegation delegation;
    protected TQuery outcome;
    protected TExpression searchBy;
    protected TDeadlines deadlines;
    protected From taskInitiator;
    protected From potentialOwners;
    protected From businessAdministrators;
    protected From taskStakeHolders;
    protected From notificationRecipients;
    protected From excludedOwners;
    protected String presentationName;
    protected String presentationSubject;
    private Map<String, String> presentationDescriptions = new HashMap<String, String>();
    private Map<String, From> presentationParameters = new HashMap<String, From>();
    private From priorityExpression;

    protected TaskDefinition() {
    }

    public TaskDefinition(TTask task, ActivityDefinitionUUID activityDefinitionUUID, BpelProcess bpelProcess) {
        this(false, activityDefinitionUUID, task.getName(), task.getPriority(), task.getPeopleAssignments(), task.getPresentationElements(), task.getRenderings(), bpelProcess);
        this.delegation = task.getDelegation();
        this.outcome = task.getOutcome();
        this.searchBy = task.getSearchBy();
        this.deadlines = task.getDeadlines();
        if (task.getInterface().getResponsePortType() != null) {
            PortType pt = bpelProcess.getWsdlInfos().getPortType(task.getInterface().getResponsePortType());
            Operation op = pt.getOperation(task.getInterface().getResponseOperation(), null, null);
            this.outputMessageType = op.getInput().getMessage().getQName();
        } else {
            PortType pt = bpelProcess.getWsdlInfos().getPortType(task.getInterface().getPortType());
            Operation op = pt.getOperation(task.getInterface().getOperation(), null, null);
            this.outputMessageType = op.getOutput().getMessage().getQName();
        }
    }

    public TaskDefinition(TNotification notification, ActivityDefinitionUUID activityDefinitionUUID, BpelProcess process) {
        this(true, activityDefinitionUUID, notification.getName(), notification.getPriority(), notification.getPeopleAssignments(), notification.getPresentationElements(), notification.getRenderings(), process);
    }

    public TaskDefinition(boolean notification, ActivityDefinitionUUID activityDefinitionUUID, String name, TPriority priority, TPeopleAssignments peopleAssignments, TPresentationElements presentationElements, TRenderings renderings, BpelProcess bpelProcess) {
        this.isNotification = notification;
        this.activityDefinitionUUID = activityDefinitionUUID;
        this.name = name;
        this.priority = priority;
        this.presentationElements = presentationElements;
        this.renderings = renderings;
        for (JAXBElement genericHumanRoleJAXBElement : peopleAssignments.getGenericHumanRole()) {
            TGenericHumanRole genericHumanRole = (TGenericHumanRole)genericHumanRoleJAXBElement.getValue();
            From from = new From();
            for (Object content : genericHumanRole.getFrom().getContent()) {
                if (!(content instanceof Element)) continue;
                Element literalElement = (Element)content;
                Document doc = XmlUtil.getNewDocument();
                doc.appendChild(doc.importNode(XmlUtil.element((Element)literalElement), true));
                Literal literal = new Literal();
                literal.setValue(doc.getDocumentElement());
                from.setLiteral(literal);
                from.setVariant(Variant.LITERAL);
            }
            if (from.getVariant() == null) {
                try {
                    JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TFrom.class});
                    Marshaller m = ctx.createMarshaller();
                    Document doc = XmlUtil.getNewDocument();
                    m.marshal((Object)new JAXBElement(new QName("http://www.example.org/WS-HT", "from"), TFrom.class, (Object)genericHumanRole.getFrom()), (Node)doc);
                    Element element = doc.getDocumentElement();
                    String expressionLanguage = XmlUtil.attribute((Element)element, (String)"expressionLanguage");
                    if (expressionLanguage == null) {
                        expressionLanguage = bpelProcess.getExpressionLanguage();
                    }
                    Expression expression = new Expression();
                    expression.setLanguage(expressionLanguage);
                    expression.setNamespaces(BpelUtil.getAllNameSpaces((Node)element));
                    expression.setText(element.getTextContent());
                    from.setVariant(Variant.EXPR);
                    from.setExpression(expression);
                }
                catch (JAXBException e) {
                    throw new OrchestraRuntimeException((Throwable)e);
                }
            }
            if (genericHumanRoleJAXBElement.getName().equals(new QName("http://www.example.org/WS-HT", "taskInitiator"))) {
                this.taskInitiator = from;
                continue;
            }
            if (genericHumanRoleJAXBElement.getName().equals(new QName("http://www.example.org/WS-HT", "potentialOwners"))) {
                this.potentialOwners = from;
                continue;
            }
            if (genericHumanRoleJAXBElement.getName().equals(new QName("http://www.example.org/WS-HT", "businessAdministrators"))) {
                this.businessAdministrators = from;
                continue;
            }
            if (genericHumanRoleJAXBElement.getName().equals(new QName("http://www.example.org/WS-HT", "taskStakeHolders"))) {
                this.taskStakeHolders = from;
                continue;
            }
            if (genericHumanRoleJAXBElement.getName().equals(new QName("http://www.example.org/WS-HT", "recipients"))) {
                this.notificationRecipients = from;
                continue;
            }
            if (!genericHumanRoleJAXBElement.getName().equals(new QName("http://www.example.org/WS-HT", "excludedOwners"))) continue;
            this.excludedOwners = from;
        }
        if (presentationElements != null) {
            StringBuilder sb;
            if (!presentationElements.getName().isEmpty()) {
                for (TText nameText : presentationElements.getName()) {
                    if (this.getPresentationName() != null && nameText.getLang() != null && !nameText.getLang().equals(Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry())) continue;
                    sb = new StringBuilder();
                    for (Object o : nameText.getContent()) {
                        if (o instanceof Node) {
                            sb.append(XmlUtil.toString((Node)((Node)o)));
                            continue;
                        }
                        sb.append(o);
                    }
                    this.presentationName = sb.toString();
                }
            }
            if (!presentationElements.getSubject().isEmpty()) {
                for (TText nameText : presentationElements.getSubject()) {
                    if (this.getPresentationSubject() != null && nameText.getLang() != null && !nameText.getLang().equals(Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry())) continue;
                    sb = new StringBuilder();
                    for (Object o : nameText.getContent()) {
                        if (o instanceof Node) {
                            sb.append(XmlUtil.toString((Node)((Node)o)));
                            continue;
                        }
                        sb.append(o);
                    }
                    this.presentationSubject = sb.toString();
                }
            }
            if (!presentationElements.getDescription().isEmpty()) {
                for (TDescription description : presentationElements.getDescription()) {
                    if (this.presentationDescriptions.containsKey(description.getContentType()) && description.getLang() != null && !description.getLang().equals(Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry())) continue;
                    sb = new StringBuilder();
                    for (Object o : description.getContent()) {
                        if (o instanceof Node) {
                            sb.append(XmlUtil.toString((Node)((Node)o)));
                            continue;
                        }
                        sb.append(o);
                    }
                    this.presentationDescriptions.put(description.getContentType(), sb.toString());
                }
            }
            if (presentationElements.getPresentationParameters() != null) {
                for (TPresentationParameter presentationParameter : presentationElements.getPresentationParameters().getPresentationParameter()) {
                    From from = new From();
                    try {
                        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TPresentationParameter.class});
                        Marshaller m = ctx.createMarshaller();
                        Document doc = XmlUtil.getNewDocument();
                        m.marshal((Object)new JAXBElement(new QName("http://www.example.org/WS-HT", "presentationParameter"), TPresentationParameter.class, (Object)presentationParameter), (Node)doc);
                        Element element = doc.getDocumentElement();
                        String expressionLanguage = presentationElements.getPresentationParameters().getExpressionLanguage();
                        if (expressionLanguage == null) {
                            expressionLanguage = bpelProcess.getExpressionLanguage();
                        }
                        Expression expression = new Expression();
                        expression.setLanguage(expressionLanguage);
                        expression.setNamespaces(BpelUtil.getAllNameSpaces((Node)element));
                        expression.setText(element.getTextContent());
                        from.setVariant(Variant.EXPR);
                        from.setExpression(expression);
                    }
                    catch (JAXBException e) {
                        throw new OrchestraRuntimeException((Throwable)e);
                    }
                    this.presentationParameters.put(presentationParameter.getName(), from);
                }
            }
        }
        if (priority != null) {
            this.priorityExpression = new From();
            try {
                JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TPriority.class});
                Marshaller m = ctx.createMarshaller();
                Document doc = XmlUtil.getNewDocument();
                m.marshal((Object)new JAXBElement(new QName("http://www.example.org/WS-HT", "priority"), TPriority.class, (Object)priority), (Node)doc);
                Element element = doc.getDocumentElement();
                String expressionLanguage = priority.getExpressionLanguage();
                if (expressionLanguage == null) {
                    expressionLanguage = bpelProcess.getExpressionLanguage();
                }
                Expression expression = new Expression();
                expression.setLanguage(expressionLanguage);
                expression.setNamespaces(BpelUtil.getAllNameSpaces((Node)element));
                expression.setText(element.getTextContent());
                this.priorityExpression.setVariant(Variant.EXPR);
                this.priorityExpression.setExpression(expression);
            }
            catch (JAXBException e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }
    }

    public QName getOutputMessageType() {
        return this.outputMessageType;
    }

    public ActivityDefinitionUUID getActivityDefinitionUUID() {
        return this.activityDefinitionUUID;
    }

    public QName getQName() {
        return new QName(this.activityDefinitionUUID.toString(), this.getName());
    }

    public boolean isNotification() {
        return this.isNotification;
    }

    public String getName() {
        return this.name;
    }

    public TPriority getPriority() {
        return this.priority;
    }

    public TPresentationElements getPresentationElements() {
        return this.presentationElements;
    }

    public TRenderings getRenderings() {
        return this.renderings;
    }

    public TDelegation getDelegation() {
        return this.delegation;
    }

    public TQuery getOutcome() {
        return this.outcome;
    }

    public TExpression getSearchBy() {
        return this.searchBy;
    }

    public TDeadlines getDeadlines() {
        return this.deadlines;
    }

    public From getTaskInitiator() {
        return this.taskInitiator;
    }

    public From getPotentialOwners() {
        return this.potentialOwners;
    }

    public From getBusinessAdministrators() {
        return this.businessAdministrators;
    }

    public From getTaskStakeHolders() {
        return this.taskStakeHolders;
    }

    public From getNotificationRecipients() {
        return this.notificationRecipients;
    }

    public From getExcludedOwners() {
        return this.excludedOwners;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public String getPresentationSubject() {
        return this.presentationSubject;
    }

    public Map<String, String> getPresentationDescriptions() {
        return this.presentationDescriptions;
    }

    public Map<String, From> getPresentationParameters() {
        return this.presentationParameters;
    }

    public From getPriorityExpression() {
        return this.priorityExpression;
    }
}

