/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.ws;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.ow2.orchestra.b4p.TaskRepository;
import org.ow2.orchestra.b4p.TaskRuntime;
import org.ow2.orchestra.b4p.ws.CurrentUser;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.ws_ht.TOrganizationalEntity;
import org.ow2.orchestra.ws_ht.api.TAttachment;
import org.ow2.orchestra.ws_ht.api.TAttachmentInfo;
import org.ow2.orchestra.ws_ht.api.TComment;
import org.ow2.orchestra.ws_ht.api.TStatus;
import org.ow2.orchestra.ws_ht.api.TTask;
import org.ow2.orchestra.ws_ht.api.TTaskAbstract;
import org.ow2.orchestra.ws_ht.api.TTaskQueryResultSet;
import org.ow2.orchestra.ws_ht.api.wsdl.IllegalAccessFault;
import org.ow2.orchestra.ws_ht.api.wsdl.IllegalArgumentFault;
import org.ow2.orchestra.ws_ht.api.wsdl.IllegalOperationFault;
import org.ow2.orchestra.ws_ht.api.wsdl.IllegalStateFault;
import org.ow2.orchestra.ws_ht.api.wsdl.RecipientNotAllowed;
import org.ow2.orchestra.ws_ht.api.wsdl.TaskOperations;
import org.ow2.orchestra.ws_ht.api.xsd.TTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOperationsImpl
implements TaskOperations {
    private WebServiceContext context;
    private TaskRepository taskRepository;

    public void setContext(WebServiceContext context) {
        this.context = context;
    }

    public void setTaskRepository(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    private String getCurrentUser() {
        if (this.context != null) {
            MessageContext ctx = this.context.getMessageContext();
            HttpServletRequest request = (HttpServletRequest)ctx.get((Object)"HTTP.REQUEST");
            if (request.getRemoteUser() != null) {
                return request.getRemoteUser();
            }
            return (String)ctx.get((Object)"javax.xml.ws.security.auth.username");
        }
        return CurrentUser.getCurrentUser();
    }

    public void nominate(String identifier, TOrganizationalEntity organizationalEntity) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.isCurrentUserBusinessAdministrator(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        this.checkTaskStatus(taskRuntime, TStatus.CREATED);
        taskRuntime.setPotentialOwners(organizationalEntity);
        if (taskRuntime.getPotentialOwners().getUsers() != null && taskRuntime.getPotentialOwners().getUsers().getUser().size() == 1) {
            taskRuntime.setActualOwner((String)taskRuntime.getPotentialOwners().getUsers().getUser().get(0));
            taskRuntime.setStatus(TStatus.RESERVED);
        } else {
            taskRuntime.setStatus(TStatus.READY);
        }
    }

    private boolean isCurrentUserBusinessAdministrator(TaskRuntime taskRuntime) throws IllegalAccessFault {
        TOrganizationalEntity businessAdmins = taskRuntime.getBusinessAdministrators();
        return businessAdmins != null && businessAdmins.getUsers().getUser().contains(this.getCurrentUser());
    }

    private boolean isCurrentUserPotentialOwner(TaskRuntime taskRuntime) {
        TOrganizationalEntity potentialOwners = taskRuntime.getPotentialOwners();
        return potentialOwners != null && potentialOwners.getUsers().getUser().contains(this.getCurrentUser());
    }

    private boolean isCurrentUserRecipient(TaskRuntime taskRuntime) {
        TOrganizationalEntity recipients = taskRuntime.getNotificationRecipients();
        return recipients != null && recipients.getUsers().getUser().contains(this.getCurrentUser());
    }

    public void getFault(String identifier, Holder<String> faultName, Holder<Object> faultData) throws IllegalArgumentFault, IllegalStateFault, IllegalOperationFault, IllegalAccessFault {
    }

    public void forward(String identifier, TOrganizationalEntity organizationalEntity) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public void deleteOutput(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public List<QName> getRenderingTypes(Object identifier) throws IllegalArgumentFault {
        return null;
    }

    public List<TComment> getComments(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        return null;
    }

    public void addAttachment(String identifier, String name, String accessType, Object attachment) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public void activate(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.isCurrentUserBusinessAdministrator(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        this.checkTaskStatus(taskRuntime, TStatus.CREATED);
        taskRuntime.setStatus(TStatus.READY);
    }

    public void setOutput(String identifier, String part, Object taskData) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.getCurrentUser().equals(taskRuntime.getActualOwner())) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        if (!taskRuntime.getOutputMessage().hasPart(part)) {
            throw new IllegalArgumentFault("Invalid part: " + part);
        }
        taskRuntime.getOutputMessage().setPart(part, taskData, true);
    }

    public void start(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        this.checkTaskStatus(taskRuntime, TStatus.READY, TStatus.RESERVED);
        if (!(taskRuntime.getStatus() == TStatus.RESERVED && this.getCurrentUser().equals(taskRuntime.getActualOwner()) || taskRuntime.getStatus() == TStatus.READY && this.isCurrentUserPotentialOwner(taskRuntime))) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        taskRuntime.setActualOwner(this.getCurrentUser());
        taskRuntime.setStatus(TStatus.IN_PROGRESS);
    }

    public TTaskQueryResultSet query(String selectClause, String whereClause, String orderByClause, Integer maxTasks, Integer taskIndexOffset) throws IllegalArgumentFault, IllegalStateFault {
        return null;
    }

    public void deleteAttachments(String identifier, String attachmentName) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public List<TTaskAbstract> getMyTaskAbstracts(String taskType, String genericHumanRole, String workQueue, List<TStatus> status, String whereClause, String createdOnClause, Integer maxTasks) throws IllegalArgumentFault, IllegalStateFault {
        return null;
    }

    public void skip(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalOperationFault, IllegalAccessFault {
    }

    public List<TAttachment> getAttachments(String identifier, String attachmentName) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        return null;
    }

    public String getTaskDescription(String identifier, String contentType) throws IllegalArgumentFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (contentType == null) {
            contentType = "text/plain";
        }
        return taskRuntime.getPresentationDescriptions().get(contentType);
    }

    public void release(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.getCurrentUser().equals(taskRuntime.getActualOwner()) && !this.isCurrentUserBusinessAdministrator(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        this.checkTaskStatus(taskRuntime, TStatus.IN_PROGRESS, TStatus.RESERVED);
        taskRuntime.setStatus(TStatus.READY);
        taskRuntime.setActualOwner(null);
    }

    public TTask getTaskInfo(String identifier) throws IllegalArgumentFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Notification not found");
        }
        return taskRuntime;
    }

    public void remove(String identifier) throws IllegalArgumentFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Notification not found");
        }
        if (!taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation only available for notifications");
        }
        if (!this.isCurrentUserRecipient(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        this.getTaskRepository().removeTaskRuntime(identifier);
    }

    public void suspend(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        this.checkTaskStatus(taskRuntime, TStatus.READY, TStatus.RESERVED, TStatus.IN_PROGRESS);
        if (!(taskRuntime.getStatus() != TStatus.READY && (this.getCurrentUser().equals(taskRuntime.getActualOwner()) || this.isCurrentUserBusinessAdministrator(taskRuntime)) || taskRuntime.getStatus() == TStatus.READY && this.isCurrentUserPotentialOwner(taskRuntime))) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        taskRuntime.setResumeState(taskRuntime.getStatus());
        taskRuntime.setStatus(TStatus.SUSPENDED);
    }

    public List<TTask> getMyTasks(String taskType, String genericHumanRole, String workQueue, List<TStatus> status, String whereClause, String createdOnClause, Integer maxTasks) throws IllegalArgumentFault, IllegalStateFault {
        return this.getTaskRepository().getTaskRuntimes(this.getCurrentUser());
    }

    public void setGenericHumanRole(String identifier, String genericHumanRole, TOrganizationalEntity organizationalEntity) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public Object getInput(String identifier, String part) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!(this.getCurrentUser().equals(taskRuntime.getActualOwner()) || this.isCurrentUserBusinessAdministrator(taskRuntime) || this.isCurrentUserPotentialOwner(taskRuntime))) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        if (!taskRuntime.getInputMessage().hasPart(part)) {
            throw new IllegalArgumentFault("Invalid part: " + part);
        }
        return taskRuntime.getInputMessage().getPartValue(part);
    }

    public Object getRendering(Object identifier, QName renderingType) throws IllegalArgumentFault {
        return null;
    }

    public void setFault(String identifier, String faultName, Object faultData) throws IllegalArgumentFault, IllegalStateFault, IllegalOperationFault, IllegalAccessFault {
    }

    public void delegate(String identifier, TOrganizationalEntity organizationalEntity) throws RecipientNotAllowed, IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public void stop(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.getCurrentUser().equals(taskRuntime.getActualOwner()) && !this.isCurrentUserBusinessAdministrator(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        this.checkTaskStatus(taskRuntime, TStatus.IN_PROGRESS);
        taskRuntime.setStatus(TStatus.RESERVED);
    }

    public Object getOutput(String identifier, String part) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.getCurrentUser().equals(taskRuntime.getActualOwner()) && !this.isCurrentUserBusinessAdministrator(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        if (!taskRuntime.getOutputMessage().hasPart(part)) {
            throw new IllegalArgumentFault("Invalid part: " + part);
        }
        return taskRuntime.getOutputMessage().getPartValue(part);
    }

    public List<TAttachmentInfo> getAttachmentInfos(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        return null;
    }

    public void suspendUntil(String identifier, TTime time) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public void addComment(String identifier, String text) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }

    public void complete(String identifier, Object taskData) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        this.checkTaskStatus(taskRuntime, TStatus.IN_PROGRESS);
        if (!this.getCurrentUser().equals(taskRuntime.getActualOwner())) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        if (taskData == null) {
            throw new IllegalArgumentFault("taskData cannot be null");
        }
        BpelExecution bpelExecution = taskRuntime.getBpelExecution();
        if (bpelExecution == null) {
            throw new OrchestraRuntimeException("Task references an unknown execution.");
        }
        MessageVariable outputMessageVariable = taskRuntime.getOutputMessage();
        if (outputMessageVariable.getParts().size() == 1) {
            String part = (String)outputMessageVariable.getParts().keySet().iterator().next();
            outputMessageVariable.setPart(part, taskData, true);
        }
        HashMap<String, MessageVariable> params = new HashMap<String, MessageVariable>();
        params.put("SIGNAL_PARAMETER_RECEIVED_MSG", outputMessageVariable);
        bpelExecution.signal(params);
        taskRuntime.setStatus(TStatus.COMPLETED);
        taskRuntime.setBpelExecution(null);
    }

    public void setPriority(String identifier, BigInteger priority) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.getCurrentUser().equals(taskRuntime.getActualOwner()) && !this.isCurrentUserBusinessAdministrator(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        taskRuntime.setPriority(priority);
    }

    public void resume(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        this.checkTaskStatus(taskRuntime, TStatus.SUSPENDED);
        if (!(taskRuntime.getResumeState() != TStatus.READY && (this.getCurrentUser().equals(taskRuntime.getActualOwner()) || this.isCurrentUserBusinessAdministrator(taskRuntime)) || taskRuntime.getResumeState() == TStatus.READY && this.isCurrentUserPotentialOwner(taskRuntime))) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        taskRuntime.setStatus(taskRuntime.getResumeState());
    }

    public void claim(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
        TaskRuntime taskRuntime = this.getTaskRepository().getTaskRuntime(identifier);
        if (taskRuntime == null) {
            throw new IllegalArgumentFault("Task not found");
        }
        if (taskRuntime.getTaskType().equals("NOTIFICATION")) {
            throw new IllegalArgumentFault("Operation not available for notifications");
        }
        if (!this.isCurrentUserBusinessAdministrator(taskRuntime) && !this.isCurrentUserPotentialOwner(taskRuntime)) {
            throw new IllegalAccessFault("user does not have permission to do this action.");
        }
        this.checkTaskStatus(taskRuntime, TStatus.READY);
        taskRuntime.setActualOwner(this.getCurrentUser());
        taskRuntime.setStatus(TStatus.RESERVED);
    }

    private void checkTaskStatus(TaskRuntime taskRuntime, TStatus ... expectedStatuses) throws IllegalStateFault {
        for (TStatus expectedStatus : expectedStatuses) {
            if (taskRuntime.getStatus() != expectedStatus) continue;
            return;
        }
        throw new IllegalStateFault("Invalid state: Task should be in " + Arrays.toString(expectedStatuses) + " state but was in " + taskRuntime.getStatus() + " state.");
    }

    public void fail(String identifier, String faultName, Object faultData) throws IllegalArgumentFault, IllegalStateFault, IllegalOperationFault, IllegalAccessFault {
    }

    public void deleteFault(String identifier) throws IllegalArgumentFault, IllegalStateFault, IllegalAccessFault {
    }
}

