/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.ow2.orchestra.b4p.B4PExtensionProviderImpl;
import org.ow2.orchestra.b4p.DbTaskRepository;
import org.ow2.orchestra.b4p.HumanTaskAPIImpl;
import org.ow2.orchestra.b4p.recorder.LoggerTaskRecorder;
import org.ow2.orchestra.b4p.ws.TaskOperationsImpl;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.EnvironmentTestCase;
import org.ow2.orchestra.ws_ht.api.TTask;
import org.ow2.orchestra.ws_ht.api.wsdl.TaskOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bpel4PeopleTestCase
extends BpelTestCase {
    public Bpel4PeopleTestCase(String namespace, String nameprocess) {
        super(namespace, nameprocess);
    }

    public DefaultEnvXMLGenerator getEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = EnvironmentTestCase.getBpelTestEnvGenerator();
        envGenerator.setApplicationEntry("b4p", "<extensionProvider class=\"" + B4PExtensionProviderImpl.class.getName() + "\" " + "name=\"b4p\">\n" + "      <arg>\n" + "        <environment-factory-ref />\n" + "      </arg>\n" + "    </extensionProvider>");
        envGenerator.addExtensionProviderType("<ref object='b4p' />");
        envGenerator.addExtension("org/ow2/orchestra/b4p/b4p.mappings.xml");
        envGenerator.setBlockEntry("taskRepository", "<object class='" + DbTaskRepository.class.getName() + "'><constructor><arg><ref object='runtime-session:core'/></arg></constructor></object>");
        envGenerator.setApplicationEntry("taskRecorder", LoggerTaskRecorder.class);
        return envGenerator;
    }

    protected String getNewTaskId(List<String> initialTaskList, String userName) throws Exception {
        for (int i = 0; i < 10; ++i) {
            List<String> newTaskList = this.getUserTaskIds(userName);
            newTaskList.removeAll(initialTaskList);
            if (newTaskList.size() == 1) {
                return newTaskList.get(0);
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)"No new task found");
        return null;
    }

    protected List<String> getUserTaskIds(String userName) throws Exception {
        ArrayList<String> taskIds = new ArrayList<String>();
        TaskOperations taskOperations = this.createTaskOperationsService(userName);
        List myTasks = taskOperations.getMyTasks("ALL", null, null, null, null, null, null);
        for (TTask task : myTasks) {
            String taskId = task.getId();
            taskIds.add(taskId);
        }
        return taskIds;
    }

    protected void activateTask(String userName, String taskId) throws Exception {
        TaskOperations taskOperations = this.createTaskOperationsService(userName);
        taskOperations.activate(taskId);
    }

    private TaskOperations createTaskOperationsService(final String userName) {
        TaskOperationsImpl taskOperationsImpl = new TaskOperationsImpl();
        Class<TaskOperations> clazz = TaskOperations.class;
        HumanTaskAPIImpl.TaskOperationsEnvironmentInterceptor interceptor = new HumanTaskAPIImpl.TaskOperationsEnvironmentInterceptor(this.getEnvironmentFactory(), taskOperationsImpl, null){

            protected String getCurrentUser() {
                return userName;
            }
        };
        TaskOperations taskOperations = (TaskOperations)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)interceptor);
        return taskOperations;
    }

    protected void startTask(String userName, String taskId) throws Exception {
        TaskOperations taskOperations = this.createTaskOperationsService(userName);
        taskOperations.start(taskId);
    }

    protected void completeTask(String userName, String taskId) throws Exception {
        TaskOperations taskOperations = this.createTaskOperationsService(userName);
        taskOperations.complete(taskId, (Object)"ok");
    }

    protected TTask getTaskInfo(String userName, String taskId) throws Exception {
        TaskOperations taskOperations = this.createTaskOperationsService(userName);
        return taskOperations.getTaskInfo(taskId);
    }

    protected void removeNotification(String userName, String taskId) throws Exception {
        TaskOperations taskOperations = this.createTaskOperationsService(userName);
        taskOperations.remove(taskId);
    }
}

