/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.test.task;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.b4p.test.Bpel4PeopleTestCase;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.ws_ht.api.TStatus;
import org.ow2.orchestra.ws_ht.api.TTask;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TaskTest
extends Bpel4PeopleTestCase {
    public TaskTest() {
        super("http://orchestra.ow2.org/task", "task");
    }

    public void testTask() throws Exception {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"));
        this.launch();
        this.undeploy();
    }

    public void testTaskExpression() throws Exception {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "Expression.bpel"));
        this.launch();
        this.undeploy();
    }

    private void launch() throws Exception {
        List<String> initialTaskList = this.getUserTaskIds("user1");
        String content = "invoke input";
        Element inputElement = XmlUtil.getDocumentWithOneElement((QName)new QName("http://localhost/task/task", "inputType"));
        Text textContent = inputElement.getOwnerDocument().createTextNode("invoke input");
        inputElement.appendChild(textContent);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("inputType", inputElement);
        QName portTypeQName = new QName("http://localhost/task/task", "portType1");
        String operationName = "operation1";
        BpelTestCase.CallResult result = this.call(parts, portTypeQName, "operation1");
        String taskId = this.getNewTaskId(initialTaskList, "user1");
        this.startTask("user1", taskId);
        TTask taskInfo = this.getTaskInfo("user1", taskId);
        Assert.assertEquals((String)"user1", (String)taskInfo.getActualOwner());
        Assert.assertEquals((String)"Helloworld", (String)taskInfo.getPresentationName());
        Assert.assertEquals((String)"Hello world !", (String)taskInfo.getPresentationSubject());
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)taskInfo.getPriority());
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)taskInfo.getStatus());
        Assert.assertEquals((String)"TASK", (String)taskInfo.getTaskType());
        this.completeTask("user1", taskId);
        MessageVariable reply = result.getMessageCarrier().getMessage();
        Assert.assertNotNull((Object)reply);
        this.deleteInstance(result);
    }
}

